"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityTrendGraph = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _helpers = require("../../../common/utils/helpers");
var _use_navigate_findings = require("../../common/hooks/use_navigate_findings");
var _use_vulnerability_dashboard_api = require("../../common/api/use_vulnerability_dashboard_api");
var _get_vulnerability_colors = require("../../common/utils/get_vulnerability_colors");
var _chart_panel = require("../../components/chart_panel");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stackAccessors = [_constants.VULNERABILITIES_SEVERITY.CRITICAL, _constants.VULNERABILITIES_SEVERITY.HIGH, _constants.VULNERABILITIES_SEVERITY.MEDIUM, _constants.VULNERABILITIES_SEVERITY.LOW];
const DEFAULT_ACCOUNT = 'all';
const chartStyle = {
  width: '100%',
  height: 300
};
const theme = {
  scales: {
    barsPadding: 0.05 // Maintains low margins between bars when chart is full
  },

  legend: {
    spacingBuffer: 45
  }
};
const ViewAllButton = () => {
  const navToVulnerabilities = (0, _use_navigate_findings.useNavigateVulnerabilities)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => navToVulnerabilities(),
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilityDashboard.viewAllButton.buttonTitle",
    defaultMessage: "View All"
  }));
};
const AccountDropDown = ({
  selectedAccount,
  setSelectedAccount,
  options = []
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
  style: {
    width: 320
  },
  compressed: true,
  prepend: _i18n.i18n.translate('xpack.csp.vulnerabilityDashboard.trendGraphChart.accountsDropDown.prepend.accountsTitle', {
    defaultMessage: 'Accounts'
  }),
  options: options,
  singleSelection: {
    asPlainText: true
  },
  isClearable: false,
  selectedOptions: options.filter(o => o.value === selectedAccount),
  onChange: selectedOption => {
    setSelectedAccount(selectedOption[0].value || DEFAULT_ACCOUNT);
  }
});
const getUniqueCloudAccountsOptions = vulnTrends => {
  const uniqueCloudAccounts = [];
  vulnTrends.forEach(trendTimepoint => {
    const accountStatss = Object.values(trendTimepoint.vulnerabilities_stats_by_cloud_account || {});
    accountStatss.forEach(accountStats => {
      // Check if the entry already exists based on the cloudAccountId
      const isDuplicate = uniqueCloudAccounts.find(account => account.value === accountStats.cloudAccountId);

      // If no duplicate is found, add the account to the uniqueCloudAccounts array
      if (!isDuplicate) {
        uniqueCloudAccounts.push({
          label: accountStats.cloudAccountName,
          value: accountStats.cloudAccountId
        });
      }
    });
  });
  uniqueCloudAccounts.unshift({
    label: _i18n.i18n.translate('xpack.csp.vulnerabilityDashboard.trendGraphChart.accountsDropDown.option.allTitle', {
      defaultMessage: 'All'
    }),
    value: DEFAULT_ACCOUNT
  });
  return uniqueCloudAccounts;
};
const getTrendData = (vulnTrends, selectedAccount) => {
  if (selectedAccount === DEFAULT_ACCOUNT) {
    const cleanAllTrend = vulnTrends.map(trendTimepoint => {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      const {
        vulnerabilities_stats_by_cloud_account,
        policy_template,
        ...allAccountsTrendData
      } = trendTimepoint;
      return allAccountsTrendData;
    });
    return cleanAllTrend;
  }
  const accountTrend = vulnTrends.map(trendTimepoint => {
    var _trendTimepoint$vulne;
    const selectedAccountStats = (_trendTimepoint$vulne = trendTimepoint.vulnerabilities_stats_by_cloud_account) === null || _trendTimepoint$vulne === void 0 ? void 0 : _trendTimepoint$vulne[selectedAccount];
    if (selectedAccountStats) return {
      '@timestamp': trendTimepoint['@timestamp'],
      ...selectedAccountStats
    };
  }).filter(_helpers.truthy);
  return accountTrend;
};
const VulnerabilityTrendGraph = () => {
  var _getVulnerabilityDash;
  const getVulnerabilityDashboard = (0, _use_vulnerability_dashboard_api.useVulnerabilityDashboardApi)();
  const vulnTrends = ((_getVulnerabilityDash = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash === void 0 ? void 0 : _getVulnerabilityDash.vulnTrends) || [];
  const [selectedAccount, setSelectedAccount] = (0, _react.useState)(DEFAULT_ACCOUNT);
  const trendData = getTrendData(vulnTrends, selectedAccount);
  const bars = (0, _react.useMemo)(() => [{
    id: _constants.VULNERABILITIES_SEVERITY.CRITICAL,
    yAccessors: ['critical'],
    color: (0, _get_vulnerability_colors.getSeverityStatusColor)(_constants.VULNERABILITIES_SEVERITY.CRITICAL)
  }, {
    id: _constants.VULNERABILITIES_SEVERITY.HIGH,
    yAccessors: ['high'],
    color: (0, _get_vulnerability_colors.getSeverityStatusColor)(_constants.VULNERABILITIES_SEVERITY.HIGH)
  }, {
    id: _constants.VULNERABILITIES_SEVERITY.MEDIUM,
    yAccessors: ['medium'],
    color: (0, _get_vulnerability_colors.getSeverityStatusColor)(_constants.VULNERABILITIES_SEVERITY.MEDIUM)
  }, {
    id: _constants.VULNERABILITIES_SEVERITY.LOW,
    yAccessors: ['low'],
    color: (0, _get_vulnerability_colors.getSeverityStatusColor)(_constants.VULNERABILITIES_SEVERITY.LOW)
  }], []);
  return /*#__PURE__*/_react.default.createElement(_chart_panel.ChartPanel, {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilityDashboard.trendGraphChart.trendBySeverityTitle', {
      defaultMessage: 'Trend by severity'
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(AccountDropDown, {
      key: "vulnerability-trend-graph-account-drop-down",
      options: getUniqueCloudAccountsOptions(vulnTrends),
      selectedAccount: selectedAccount,
      setSelectedAccount: setSelectedAccount
    }), /*#__PURE__*/_react.default.createElement(ViewAllButton, {
      key: "vulnerability-trend-graph-view-all-button"
    })]
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: chartStyle
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    legendPosition: "right",
    showLegend: true,
    theme: theme
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: 'bottom',
    tickFormat: (0, _charts.timeFormatter)((0, _charts.niceTimeFormatByDay)(2))
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: 'left',
    tickFormat: number => number.toLocaleString()
  }), bars.map(bar => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    key: bar.id,
    id: bar.id,
    xAccessor: '@timestamp',
    yAccessors: bar.yAccessors,
    stackAccessors: stackAccessors,
    data: trendData,
    color: bar.color,
    minBarHeight: 5,
    barSeriesStyle: {
      rect: {
        // Limiting bars max width before 25 days of data
        widthPixel: trendData.length < 25 ? 50 : undefined
      }
    }
  })))));
};
exports.VulnerabilityTrendGraph = VulnerabilityTrendGraph;