"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsGroupBySelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/navigation/constants");
var TEST_SUBJECTS = _interopRequireWildcard(require("../test_subjects"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGroupByOptions = () => [{
  value: 'default',
  label: _i18n.i18n.translate('xpack.csp.findings.groupBySelector.groupByNoneLabel', {
    defaultMessage: 'None'
  })
}, {
  value: 'resource',
  label: _i18n.i18n.translate('xpack.csp.findings.groupBySelector.groupByResourceIdLabel', {
    defaultMessage: 'Resource'
  })
}];
const getFindingsGroupPath = opts => {
  const [firstOption] = opts;
  switch (firstOption === null || firstOption === void 0 ? void 0 : firstOption.value) {
    case 'resource':
      return _constants.findingsNavigation.findings_by_resource.path;
    case 'default':
    default:
      return _constants.findingsNavigation.findings_default.path;
  }
};
const FindingsGroupBySelector = ({
  type,
  pathnameHandler = getFindingsGroupPath
}) => {
  const groupByOptions = (0, _react.useMemo)(getGroupByOptions, []);
  const history = (0, _reactRouterDom.useHistory)();
  const onChange = options => history.push({
    pathname: pathnameHandler(options)
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": TEST_SUBJECTS.FINDINGS_GROUP_BY_SELECTOR,
    prepend: /*#__PURE__*/_react.default.createElement(GroupByLabel, null),
    singleSelection: {
      asPlainText: true
    },
    options: groupByOptions,
    selectedOptions: groupByOptions.filter(o => o.value === type),
    onChange: onChange,
    isClearable: false,
    compressed: true
  });
};
exports.FindingsGroupBySelector = FindingsGroupBySelector;
const GroupByLabel = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.findings.groupBySelector.groupByLabel",
  defaultMessage: "Group by"
}));