"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Markdown = exports.FindingsRuleFlyout = exports.CodeBlock = exports.CisKubernetesIcons = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _std = require("@kbn/std");
var _i18n = require("@kbn/i18n");
var _cis_logo = _interopRequireDefault(require("../../../assets/icons/cis_logo.svg"));
var _csp_evaluation_badge = require("../../../components/csp_evaluation_badge");
var _table_tab = require("./table_tab");
var _json_tab = require("./json_tab");
var _overview_tab = require("./overview_tab");
var _rule_tab = require("./rule_tab");
var _cis_benchmark_icon = require("../../../components/cis_benchmark_icon");
var _test_subjects = require("../test_subjects");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabs = [{
  id: 'overview',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTabTitle', {
    defaultMessage: 'Overview'
  })
}, {
  id: 'rule',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTabTitle', {
    defaultMessage: 'Rule'
  })
}, {
  id: 'table',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.tableTabTitle', {
    defaultMessage: 'Table'
  })
}, {
  id: 'json',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.jsonTabTitle', {
    defaultMessage: 'JSON'
  })
}];
const PAGINATION_LABEL = _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.paginationLabel', {
  defaultMessage: 'Finding navigation'
});
const CodeBlock = props => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, (0, _extends2.default)({
  isCopyable: true,
  paddingSize: "s",
  overflowHeight: 300
}, props));
exports.CodeBlock = CodeBlock;
const Markdown = props => /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, (0, _extends2.default)({
  textSize: "s"
}, props));
exports.Markdown = Markdown;
const CisKubernetesIcons = ({
  benchmarkId,
  benchmarkName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: _cis_logo.default,
  size: "xxl"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
  type: benchmarkId,
  name: benchmarkName
})));
exports.CisKubernetesIcons = CisKubernetesIcons;
const FindingsTab = ({
  tab,
  findings
}) => {
  switch (tab.id) {
    case 'overview':
      return /*#__PURE__*/_react.default.createElement(_overview_tab.OverviewTab, {
        data: findings
      });
    case 'rule':
      return /*#__PURE__*/_react.default.createElement(_rule_tab.RuleTab, {
        data: findings
      });
    case 'table':
      return /*#__PURE__*/_react.default.createElement(_table_tab.TableTab, {
        data: findings
      });
    case 'json':
      return /*#__PURE__*/_react.default.createElement(_json_tab.JsonTab, {
        data: findings
      });
    default:
      (0, _std.assertNever)(tab);
  }
};
const FindingsRuleFlyout = ({
  onClose,
  findings,
  flyoutIndex,
  findingsCount,
  onPaginate
}) => {
  const [tab, setTab] = (0, _react.useState)(tabs[0]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": _test_subjects.FINDINGS_FLYOUT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_csp_evaluation_badge.CspEvaluationBadge, {
    type: findings.result.evaluation
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "primary",
    title: findings.rule.name
  }, findings.rule.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs.map(v => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: v.id,
    isSelected: tab.id === v.id,
    onClick: () => setTab(v),
    "data-test-subj": `findings_flyout_tab_${v.id}`
  }, v.title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    key: tab.id
  }, /*#__PURE__*/_react.default.createElement(FindingsTab, {
    tab: tab,
    findings: findings
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": PAGINATION_LABEL,
    pageCount: findingsCount,
    activePage: flyoutIndex,
    onPageClick: onPaginate,
    compressed: true
  })))));
};
exports.FindingsRuleFlyout = FindingsRuleFlyout;