"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAwsVarsGroup = exports.AwsCredentialsForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _get_aws_credentials_form_options = require("./get_aws_credentials_form_options");
var _csp_boxed_radio_group = require("../csp_boxed_radio_group");
var _utils = require("../utils");
var _hooks = require("./hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AWSSetupInfoContent = ({
  integrationLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.awsIntegration.setupInfoContentTitle",
    defaultMessage: "Setup Access"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.awsIntegration.gettingStarted.setupInfoContent",
    defaultMessage: "Utilize AWS CloudFormation (a built-in AWS tool) or a series of manual steps to set up and deploy CSPM for assessing your AWS environment's security posture. Refer to our {gettingStartedLink} guide for details.",
    values: {
      gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: integrationLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.awsIntegration.gettingStarted.setupInfoContentLink",
        defaultMessage: "Getting Started"
      }))
    }
  })));
};
const getSetupFormatOptions = () => [{
  id: 'cloud_formation',
  label: 'CloudFormation'
}, {
  id: 'manual',
  label: _i18n.i18n.translate('xpack.csp.awsIntegration.setupFormatOptions.manual', {
    defaultMessage: 'Manual'
  })
}];
const getDefaultAwsVarsGroup = packageInfo => {
  const hasCloudFormationTemplate = !!(0, _utils.getCspmCloudFormationDefaultValue)(packageInfo);
  if (hasCloudFormationTemplate) {
    return 'cloud_formation';
  }
  return _get_aws_credentials_form_options.DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE;
};
exports.getDefaultAwsVarsGroup = getDefaultAwsVarsGroup;
const CloudFormationSetup = ({
  hasCloudFormationTemplate
}) => {
  if (!hasCloudFormationTemplate) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.awsIntegration.cloudFormationSetupStep.notSupported",
      defaultMessage: "CloudFormation is not supported on the current Integration version, please upgrade your integration to the latest version to use CloudFormation"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("ol", {
    css: (0, _react2.css)`
            list-style: auto;
          `
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.awsIntegration.cloudFormationSetupStep.login",
    defaultMessage: "Log in as an admin to the AWS Account you want to onboard"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.awsIntegration.cloudFormationSetupStep.save",
    defaultMessage: "Click the Save and continue button on the bottom right of this page"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.awsIntegration.cloudFormationSetupStep.launch",
    defaultMessage: "On the subsequent pop-up modal, click the Launch CloudFormation button."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(ReadDocumentation, {
    url: CLOUD_FORMATION_EXTERNAL_DOC_URL
  }));
};
const CLOUD_FORMATION_EXTERNAL_DOC_URL = 'https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-howdoesitwork.html';
const Link = ({
  children,
  url
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: url,
  target: "_blank",
  rel: "noopener nofollow noreferrer",
  "data-test-subj": "externalLink"
}, children);
const ReadDocumentation = ({
  url
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.awsIntegration.cloudFormationSetupNote",
    defaultMessage: "Read the {documentation} for more details",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(Link, {
        url: url
      }, _i18n.i18n.translate('xpack.csp.awsIntegration.documentationLinkText', {
        defaultMessage: 'documentation'
      }))
    }
  }));
};
const AwsCredentialsForm = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo,
  onChange,
  setIsValid
}) => {
  const {
    awsCredentialsType,
    setupFormat,
    group,
    fields,
    integrationLink,
    hasCloudFormationTemplate,
    onSetupFormatChange
  } = (0, _hooks.useAwsCredentialsForm)({
    newPolicy,
    input,
    packageInfo,
    onChange,
    setIsValid,
    updatePolicy
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AWSSetupInfoContent, {
    integrationLink: integrationLink
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
    size: "m",
    options: getSetupFormatOptions(),
    idSelected: setupFormat,
    onChange: onSetupFormatChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), setupFormat === 'cloud_formation' && /*#__PURE__*/_react.default.createElement(CloudFormationSetup, {
    hasCloudFormationTemplate: hasCloudFormationTemplate
  }), setupFormat === 'manual' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AwsCredentialTypeSelector, {
    type: awsCredentialsType,
    onChange: optionId => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'aws.credentials.type': {
          value: optionId
        }
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), group.info, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ReadDocumentation, {
    url: integrationLink
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(AwsInputVarFields, {
    fields: fields,
    onChange: (key, value) => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        [key]: {
          value
        }
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.AwsCredentialsForm = AwsCredentialsForm;
const AwsCredentialTypeSelector = ({
  type,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  fullWidth: true,
  label: _i18n.i18n.translate('xpack.csp.awsIntegration.awsCredentialTypeSelectorLabel', {
    defaultMessage: 'Preferred manual method'
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  fullWidth: true,
  options: (0, _get_aws_credentials_form_options.getAwsCredentialsFormManualOptions)(),
  value: type,
  onChange: optionElem => {
    onChange(optionElem.target.value);
  }
}));
const AwsInputVarFields = ({
  fields,
  onChange
}) => /*#__PURE__*/_react.default.createElement("div", null, fields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  key: field.id,
  label: field.label,
  fullWidth: true,
  hasChildLabel: true,
  id: field.id
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, field.type === 'password' && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
  id: field.id,
  type: "dual",
  fullWidth: true,
  value: field.value || '',
  onChange: event => onChange(field.id, event.target.value)
}), field.type === 'text' && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  id: field.id,
  fullWidth: true,
  value: field.value || '',
  onChange: event => onChange(field.id, event.target.value)
})))));