"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnabledCspIntegrationDetails = void 0;
var _constants = require("../../../common/constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isPolicyTemplate = name => typeof name === 'string' && name in _constants2.cloudPostureIntegrations;
const getEnabledCspIntegrationDetails = packageInfo => {
  const enabledInput = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.inputs.find(input => input.enabled);

  // Check for valid and support input
  if (!enabledInput || !isPolicyTemplate(enabledInput.policy_template) || !_constants.SUPPORTED_CLOUDBEAT_INPUTS.includes(enabledInput.type)) return null;
  const integration = _constants2.cloudPostureIntegrations[enabledInput.policy_template];
  const enabledIntegrationOption = integration.options.find(option => option.type === enabledInput.type);
  return {
    integration,
    enabledIntegrationOption
  };
};
exports.getEnabledCspIntegrationDetails = getEnabledCspIntegrationDetails;