"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CSP_FLEET_PACKAGE_KUERY = void 0;
exports.assert = assert;
exports.truthy = exports.roundScore = exports.isNonNullable = exports.isEnabledBenchmarkInputType = exports.isCspPackage = exports.getBenchmarkTypeFilter = exports.getBenchmarkFromPackagePolicy = exports.extractErrorMessage = exports.calculatePostureScore = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @example
 * declare const foo: Array<string | undefined | null>
 * foo.filter(isNonNullable) // foo is Array<string>
 */
const isNonNullable = v => v !== null && v !== undefined;
exports.isNonNullable = isNonNullable;
const truthy = value => !!value;
exports.truthy = truthy;
const extractErrorMessage = (e, defaultMessage = 'Unknown Error') => {
  if (e instanceof Error) return e.message;
  if (typeof e === 'string') return e;
  return defaultMessage; // TODO: i18n
};
exports.extractErrorMessage = extractErrorMessage;
const getBenchmarkTypeFilter = type => `${_constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE}.attributes.metadata.benchmark.id: "${type}"`;
exports.getBenchmarkTypeFilter = getBenchmarkTypeFilter;
const isEnabledBenchmarkInputType = input => input.enabled;
exports.isEnabledBenchmarkInputType = isEnabledBenchmarkInputType;
const isCspPackage = packageName => packageName === _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME;
exports.isCspPackage = isCspPackage;
const getBenchmarkFromPackagePolicy = inputs => {
  const enabledInputs = inputs.filter(isEnabledBenchmarkInputType);

  // Use the only enabled input
  if (enabledInputs.length === 1) {
    return getInputType(enabledInputs[0].type);
  }

  // Use the default benchmark id for multiple/none selected
  return getInputType(_constants.CLOUDBEAT_VANILLA);
};
exports.getBenchmarkFromPackagePolicy = getBenchmarkFromPackagePolicy;
const getInputType = inputType => {
  // Get the last part of the input type, input type structure: cloudbeat/<benchmark_id>
  return inputType.split('/')[1];
};
const CSP_FLEET_PACKAGE_KUERY = `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME}`;
exports.CSP_FLEET_PACKAGE_KUERY = CSP_FLEET_PACKAGE_KUERY;
function assert(condition, msg) {
  if (!condition) {
    throw new Error(msg);
  }
}

/**
 * @param value value is [0, 1] range
 */
const roundScore = value => Number((value * 100).toFixed(1));
exports.roundScore = roundScore;
const calculatePostureScore = (passed, failed) => {
  const total = passed + failed;
  if (total === 0) return total;
  return roundScore(passed / (passed + failed));
};
exports.calculatePostureScore = calculatePostureScore;