"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _register_cloud_deployment_id_analytics_context = require("../common/register_cloud_deployment_id_analytics_context");
var _collectors = require("./collectors");
var _is_cloud_enabled = require("../common/is_cloud_enabled");
var _parse_deployment_id_from_deployment_url = require("../common/parse_deployment_id_from_deployment_url");
var _decode_cloud_id = require("../common/decode_cloud_id");
var _env = require("./env");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.context = context;
    this.config = this.context.config.get();
    this.logger = this.context.logger.get();
  }
  setup(core, {
    usageCollection
  }) {
    var _decodedId, _decodedId2, _decodedId3, _decodedId4, _this$config$apm, _this$config$apm2;
    const isCloudEnabled = (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id);
    (0, _register_cloud_deployment_id_analytics_context.registerCloudDeploymentMetadataAnalyticsContext)(core.analytics, this.config);
    (0, _collectors.registerCloudUsageCollector)(usageCollection, {
      isCloudEnabled,
      trialEndDate: this.config.trial_end_date,
      isElasticStaffOwned: this.config.is_elastic_staff_owned
    });
    let decodedId;
    if (this.config.id) {
      decodedId = (0, _decode_cloud_id.decodeCloudId)(this.config.id, this.logger);
    }
    return {
      cloudId: this.config.id,
      instanceSizeMb: (0, _env.readInstanceSizeMb)(),
      deploymentId: (0, _parse_deployment_id_from_deployment_url.parseDeploymentIdFromDeploymentUrl)(this.config.deployment_url),
      elasticsearchUrl: (_decodedId = decodedId) === null || _decodedId === void 0 ? void 0 : _decodedId.elasticsearchUrl,
      kibanaUrl: (_decodedId2 = decodedId) === null || _decodedId2 === void 0 ? void 0 : _decodedId2.kibanaUrl,
      cloudHost: (_decodedId3 = decodedId) === null || _decodedId3 === void 0 ? void 0 : _decodedId3.host,
      cloudDefaultPort: (_decodedId4 = decodedId) === null || _decodedId4 === void 0 ? void 0 : _decodedId4.defaultPort,
      isCloudEnabled,
      trialEndDate: this.config.trial_end_date ? new Date(this.config.trial_end_date) : undefined,
      isElasticStaffOwned: this.config.is_elastic_staff_owned,
      apm: {
        url: (_this$config$apm = this.config.apm) === null || _this$config$apm === void 0 ? void 0 : _this$config$apm.url,
        secretToken: (_this$config$apm2 = this.config.apm) === null || _this$config$apm2 === void 0 ? void 0 : _this$config$apm2.secret_token
      }
    };
  }
  start() {
    return {
      isCloudEnabled: (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id)
    };
  }
}
exports.CloudPlugin = CloudPlugin;