"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudChatProviderPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudChatProviderPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "getChat", void 0);
  }
  setup(core) {
    return {
      registerChatProvider: getChat => {
        if (this.getChat) {
          throw new Error('Chat component has already been provided');
        }
        this.getChat = getChat;
      }
    };
  }
  start(core) {
    return {
      Chat: () => {
        var _this$getChat;
        const Chat = (_this$getChat = this.getChat) === null || _this$getChat === void 0 ? void 0 : _this$getChat.call(this);
        return Chat ? /*#__PURE__*/_react.default.createElement(Chat, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      }
    };
  }
  stop() {}
}
exports.CloudChatProviderPlugin = CloudChatProviderPlugin;