"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudChatPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _constants = require("../common/constants");
var _services = require("./services");
var _util = require("../common/util");
var _components = require("./components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudChatPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "chatConfig$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "Chat", void 0);
    (0, _defineProperty2.default)(this, "kbnVersion", void 0);
    (0, _defineProperty2.default)(this, "kbnBuildNum", void 0);
    this.kbnVersion = initializerContext.env.packageInfo.version;
    this.kbnBuildNum = initializerContext.env.packageInfo.buildNum;
    this.config = initializerContext.config.get();
  }
  setup(core, {
    cloud,
    security,
    cloudChatProvider
  }) {
    this.setupChat({
      http: core.http,
      cloud,
      security,
      cloudChatProvider
    }).catch(e =>
    // eslint-disable-next-line no-console
    console.debug(`Error setting up Chat: ${e.toString()}`));
    const CloudChatContextProvider = ({
      children
    }) => {
      // There's a risk that the request for chat config will take too much time to complete, and the provider
      // will maintain a stale value.  To avoid this, we'll use an Observable.
      const chatConfig = (0, _useObservable.default)(this.chatConfig$, undefined);
      return /*#__PURE__*/_react.default.createElement(_services.ServicesProvider, {
        chat: chatConfig
      }, children);
    };
    cloud.registerCloudService(CloudChatContextProvider);
    cloudChatProvider.registerChatProvider(() => this.Chat);
  }
  start(core, {
    cloud
  }) {
    const CloudContextProvider = cloud.CloudContextProvider;
    this.Chat = () => /*#__PURE__*/_react.default.createElement(CloudContextProvider, null, /*#__PURE__*/_react.default.createElement(_components.Chat, null));
    return {
      Chat: this.Chat
    };
  }
  stop() {}
  async setupChat({
    cloud,
    http,
    security
  }) {
    const {
      isCloudEnabled,
      trialEndDate
    } = cloud;
    const {
      chatURL,
      trialBuffer
    } = this.config;
    if (!security || !isCloudEnabled || !chatURL || !trialEndDate || !(0, _util.isTodayInDateWindow)(trialEndDate, trialBuffer)) {
      return;
    }
    try {
      const {
        email,
        id,
        token: jwt
      } = await http.get(_constants.GET_CHAT_USER_DATA_ROUTE_PATH);
      if (!email || !id || !jwt) {
        return;
      }
      this.chatConfig$.next({
        chatURL,
        user: {
          email,
          id,
          jwt,
          trialEndDate: trialEndDate,
          kbnVersion: this.kbnVersion,
          kbnBuildNum: this.kbnBuildNum
        }
      });
    } catch (e) {
      // eslint-disable-next-line no-console
      console.debug(`[cloud.chat] Could not retrieve chat config: ${e.response.status} ${e.message}`, e);
    }
  }
}
exports.CloudChatPlugin = CloudChatPlugin;