"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createColorPalette = createColorPalette;
var _lodash = _interopRequireDefault(require("lodash"));
var _color = require("color");
var _seed_colors = require("./seed_colors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const offset = 300; // Hue offset to start at

const fraction = function (goal) {
  const walkTree = (numerator, denominator, bytes) => {
    if (bytes.length) {
      return walkTree(numerator * 2 + (bytes.pop() ? 1 : -1), denominator * 2, bytes);
    } else {
      return numerator / denominator;
    }
  };
  const b = (goal + 2).toString(2).split('').map(function (num) {
    return parseInt(num, 10);
  });
  b.shift();
  return walkTree(1, 2, b);
};

/**
 * Generates an array of hex colors the length of the input number.
 * If the number is greater than the length of seed colors available,
 * new colors are generated up to the value of the input number.
 */
function createColorPalette(num) {
  if (!_lodash.default.isNumber(num)) {
    throw new TypeError('ColorPaletteUtilService expects a number');
  }
  const colors = _seed_colors.seedColors;
  const seedLength = _seed_colors.seedColors.length;
  _lodash.default.times(num - seedLength, function (i) {
    colors.push((0, _color.hsl)((fraction(i + seedLength + 1) * 360 + offset) % 360, 50, 50).hex());
  });
  return colors;
}