"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryUserActionBuilder = void 0;
var _constants = require("../../../../common/constants");
var _api = require("../../../../common/api");
var _abstract_builder = require("../abstract_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CategoryUserActionBuilder extends _abstract_builder.UserActionBuilder {
  build(args) {
    const value = args.payload.category;
    const action = value != null ? _api.Actions.update : _api.Actions.delete;
    const parameters = this.buildCommonUserAction({
      ...args,
      action,
      valueKey: 'category',
      value,
      type: _api.ActionTypes.category
    });
    const getMessage = id => `User updated the category for case id: ${args.caseId} - user action id: ${id}`;
    const eventDetails = {
      getMessage,
      action,
      descriptiveAction: 'case_user_action_update_case_category',
      savedObjectId: args.caseId,
      savedObjectType: _constants.CASE_SAVED_OBJECT
    };
    return {
      parameters,
      eventDetails
    };
  }
}
exports.CategoryUserActionBuilder = CategoryUserActionBuilder;