"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findCommentsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _api = require("../../../../common/api");
var _constants = require("../../../../common/constants");
var _create_cases_route = require("../create_cases_route");
var _error = require("../../../common/error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findCommentsRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'get',
  path: _constants.CASE_FIND_ATTACHMENTS_URL,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string()
    })
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const query = (0, _api.decodeWithExcessOrThrow)(_api.FindCommentsQueryParamsRt)(request.query);
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      return response.ok({
        body: await client.attachments.find({
          caseID: request.params.case_id,
          findQueryParams: query
        })
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to find comments in route case id: ${request.params.case_id}: ${error}`,
        error
      });
    }
  }
});
exports.findCommentsRoute = findCommentsRoute;