"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertLimiter = void 0;
var _api = require("../../../../common/api");
var _constants = require("../../../../common/constants");
var _utils = require("../../utils");
var _base_limiter = require("../base_limiter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AlertLimiter extends _base_limiter.BaseLimiter {
  constructor(attachmentService) {
    super({
      limit: _constants.MAX_ALERTS_PER_CASE,
      attachmentType: _api.CommentType.alert,
      attachmentNoun: 'alerts',
      field: 'alertId'
    });
    this.attachmentService = attachmentService;
  }
  async countOfItemsWithinCase(caseId) {
    var _itemsAttachedToCase$, _itemsAttachedToCase$2;
    const limitAggregation = {
      limiter: {
        value_count: {
          field: `${_constants.CASE_COMMENT_SAVED_OBJECT}.attributes.alertId`
        }
      }
    };
    const itemsAttachedToCase = await this.attachmentService.executeCaseAggregations({
      caseId,
      aggregations: limitAggregation,
      attachmentType: _api.CommentType.alert
    });
    return (_itemsAttachedToCase$ = itemsAttachedToCase === null || itemsAttachedToCase === void 0 ? void 0 : (_itemsAttachedToCase$2 = itemsAttachedToCase.limiter) === null || _itemsAttachedToCase$2 === void 0 ? void 0 : _itemsAttachedToCase$2.value) !== null && _itemsAttachedToCase$ !== void 0 ? _itemsAttachedToCase$ : 0;
  }
  countOfItemsInRequest(requests) {
    const totalAlertsInReq = requests.filter(_utils.isCommentRequestTypeAlert).reduce((count, attachment) => {
      const ids = Array.isArray(attachment.alertId) ? attachment.alertId : [attachment.alertId];
      return count + ids.length;
    }, 0);
    return totalAlertsInReq;
  }
}
exports.AlertLimiter = AlertLimiter;