"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseConfigure = exports.initialState = exports.configureCasesReducer = void 0;
var _react = require("react");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
var _api2 = require("../../../common/api");
var _kibana = require("../../common/lib/kibana");
var _use_cases_context = require("../../components/cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configureCasesReducer = (state, action) => {
  switch (action.type) {
    case 'setLoading':
      return {
        ...state,
        loading: action.payload
      };
    case 'setFirstLoad':
      return {
        ...state,
        firstLoad: action.payload
      };
    case 'setPersistLoading':
      return {
        ...state,
        persistLoading: action.payload
      };
    case 'setVersion':
      return {
        ...state,
        version: action.payload
      };
    case 'setID':
      return {
        ...state,
        id: action.payload
      };
    case 'setCurrentConfiguration':
      {
        return {
          ...state,
          currentConfiguration: {
            ...action.currentConfiguration
          }
        };
      }
    case 'setConnector':
      {
        return {
          ...state,
          connector: action.connector
        };
      }
    case 'setClosureType':
      {
        return {
          ...state,
          closureType: action.closureType
        };
      }
    case 'setMappings':
      {
        return {
          ...state,
          mappings: action.mappings
        };
      }
    default:
      return state;
  }
};
exports.configureCasesReducer = configureCasesReducer;
const initialState = {
  closureType: 'close-by-user',
  connector: {
    fields: null,
    id: 'none',
    name: 'none',
    type: _api2.ConnectorTypes.none
  },
  currentConfiguration: {
    closureType: 'close-by-user',
    connector: {
      fields: null,
      id: 'none',
      name: 'none',
      type: _api2.ConnectorTypes.none
    }
  },
  firstLoad: false,
  loading: true,
  mappings: [],
  persistLoading: false,
  version: '',
  id: ''
};
exports.initialState = initialState;
const useCaseConfigure = () => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const [state, dispatch] = (0, _react.useReducer)(configureCasesReducer, initialState);
  const toasts = (0, _kibana.useToasts)();
  const setCurrentConfiguration = (0, _react.useCallback)(configuration => {
    dispatch({
      currentConfiguration: configuration,
      type: 'setCurrentConfiguration'
    });
  }, []);
  const setConnector = (0, _react.useCallback)(connector => {
    dispatch({
      connector,
      type: 'setConnector'
    });
  }, []);
  const setClosureType = (0, _react.useCallback)(closureType => {
    dispatch({
      closureType,
      type: 'setClosureType'
    });
  }, []);
  const setMappings = (0, _react.useCallback)(mappings => {
    dispatch({
      mappings,
      type: 'setMappings'
    });
  }, []);
  const setLoading = (0, _react.useCallback)(isLoading => {
    dispatch({
      payload: isLoading,
      type: 'setLoading'
    });
  }, []);
  const setFirstLoad = (0, _react.useCallback)(isFirstLoad => {
    dispatch({
      payload: isFirstLoad,
      type: 'setFirstLoad'
    });
  }, []);
  const setPersistLoading = (0, _react.useCallback)(isPersistLoading => {
    dispatch({
      payload: isPersistLoading,
      type: 'setPersistLoading'
    });
  }, []);
  const setVersion = (0, _react.useCallback)(version => {
    dispatch({
      payload: version,
      type: 'setVersion'
    });
  }, []);
  const setID = (0, _react.useCallback)(id => {
    dispatch({
      payload: id,
      type: 'setID'
    });
  }, []);
  const isCancelledRefetchRef = (0, _react.useRef)(false);
  const abortCtrlRefetchRef = (0, _react.useRef)(new AbortController());
  const isCancelledPersistRef = (0, _react.useRef)(false);
  const abortCtrlPersistRef = (0, _react.useRef)(new AbortController());
  const refetchCaseConfigure = (0, _react.useCallback)(async () => {
    try {
      isCancelledRefetchRef.current = false;
      abortCtrlRefetchRef.current.abort();
      abortCtrlRefetchRef.current = new AbortController();
      setLoading(true);
      const res = await (0, _api.getCaseConfigure)({
        signal: abortCtrlRefetchRef.current.signal,
        owner
      });
      if (!isCancelledRefetchRef.current) {
        if (res != null) {
          setConnector(res.connector);
          if (setClosureType != null) {
            setClosureType(res.closureType);
          }
          setVersion(res.version);
          setID(res.id);
          setMappings(res.mappings);
          if (!state.firstLoad) {
            setFirstLoad(true);
            if (setCurrentConfiguration != null) {
              setCurrentConfiguration({
                closureType: res.closureType,
                connector: {
                  ...res.connector
                }
              });
            }
          }
          if (res.error != null) {
            toasts.addError(new Error(res.error), {
              title: i18n.ERROR_TITLE
            });
          }
        }
        setLoading(false);
      }
    } catch (error) {
      if (!isCancelledRefetchRef.current) {
        if (error.name !== 'AbortError') {
          toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
            title: i18n.ERROR_TITLE
          });
        }
        setLoading(false);
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [state.firstLoad]);
  const persistCaseConfigure = (0, _react.useCallback)(async ({
    connector,
    closureType
  }) => {
    try {
      isCancelledPersistRef.current = false;
      abortCtrlPersistRef.current.abort();
      abortCtrlPersistRef.current = new AbortController();
      setPersistLoading(true);
      const connectorObj = {
        connector,
        closure_type: closureType
      };
      const res = state.version.length === 0 ? await (0, _api.postCaseConfigure)(
      // The first owner will be used for case creation
      {
        ...connectorObj,
        owner: owner[0]
      }, abortCtrlPersistRef.current.signal) : await (0, _api.patchCaseConfigure)(state.id, {
        ...connectorObj,
        version: state.version
      }, abortCtrlPersistRef.current.signal);
      if (!isCancelledPersistRef.current) {
        setConnector(res.connector);
        if (setClosureType) {
          setClosureType(res.closureType);
        }
        setVersion(res.version);
        setID(res.id);
        setMappings(res.mappings);
        if (setCurrentConfiguration != null) {
          setCurrentConfiguration({
            closureType: res.closureType,
            connector: {
              ...res.connector
            }
          });
        }
        if (res.error != null) {
          toasts.addError(new Error(res.error), {
            title: i18n.ERROR_TITLE
          });
        }
        toasts.addSuccess(i18n.SUCCESS_CONFIGURE);
        setPersistLoading(false);
      }
    } catch (error) {
      if (!isCancelledPersistRef.current) {
        if (error.name !== 'AbortError') {
          toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
            title: i18n.ERROR_TITLE
          });
        }
        setConnector(state.currentConfiguration.connector);
        setPersistLoading(false);
      }
    }
  }, [setPersistLoading, state.version, state.id, state.currentConfiguration.connector, owner, setConnector, setClosureType, setVersion, setID, setMappings, setCurrentConfiguration, toasts]);
  (0, _react.useEffect)(() => {
    refetchCaseConfigure();
    return () => {
      isCancelledRefetchRef.current = true;
      abortCtrlRefetchRef.current.abort();
      isCancelledPersistRef.current = true;
      abortCtrlPersistRef.current.abort();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    ...state,
    refetchCaseConfigure,
    persistCaseConfigure,
    setCurrentConfiguration,
    setConnector,
    setClosureType,
    setMappings
  };
};
exports.useCaseConfigure = useCaseConfigure;