"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddToExistingCaseLensAction = exports.DEFAULT_DARK_MODE = exports.ACTION_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _utils = require("./utils");
var _use_cases_add_to_existing_case_modal = require("../../all_cases/selector_modal/use_cases_add_to_existing_case_modal");
var _translations = require("./translations");
var _action_wrapper = require("./action_wrapper");
var _can_use_cases = require("../../../client/helpers/can_use_cases");
var _owner = require("../../../../common/utils/owner");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_ID = 'embeddable_addToExistingCase';
exports.ACTION_ID = ACTION_ID;
const DEFAULT_DARK_MODE = 'theme:darkMode';
exports.DEFAULT_DARK_MODE = DEFAULT_DARK_MODE;
const AddExistingCaseModalWrapper = ({
  embeddable,
  onClose,
  onSuccess
}) => {
  const modal = (0, _use_cases_add_to_existing_case_modal.useCasesAddToExistingCaseModal)({
    onClose,
    onSuccess
  });
  const attachments = (0, _react.useMemo)(() => {
    const {
      timeRange
    } = embeddable.getInput();
    const attributes = embeddable.getFullAttributes();
    // we've checked attributes exists before rendering (isCompatible), attributes should not be undefined here
    return attributes != null ? [(0, _utils.getLensCaseAttachment)({
      attributes,
      timeRange
    })] : [];
  }, [embeddable]);
  (0, _react.useEffect)(() => {
    modal.open({
      getAttachments: () => attachments
    });
  }, [attachments, modal]);
  return null;
};
AddExistingCaseModalWrapper.displayName = 'AddExistingCaseModalWrapper';
const createAddToExistingCaseLensAction = ({
  core,
  plugins,
  storage,
  history,
  caseContextProps
}) => {
  const {
    application: applicationService,
    theme
  } = core;
  let currentAppId;
  applicationService === null || applicationService === void 0 ? void 0 : applicationService.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  return (0, _public.createAction)({
    id: ACTION_ID,
    type: 'actionButton',
    getIconType: () => 'casesApp',
    getDisplayName: () => _translations.ADD_TO_EXISTING_CASE_DISPLAYNAME,
    isCompatible: async ({
      embeddable
    }) => {
      const owner = (0, _owner.getCaseOwnerByAppId)(currentAppId);
      const casePermissions = (0, _can_use_cases.canUseCases)(applicationService.capabilities)(owner ? [owner] : undefined);
      return !(0, _public2.isErrorEmbeddable)(embeddable) && (0, _utils.isLensEmbeddable)(embeddable) && casePermissions.update && casePermissions.create && (0, _utils.hasInput)(embeddable);
    },
    execute: async ({
      embeddable
    }) => {
      const targetDomElement = document.createElement('div');
      const cleanupDom = shouldCleanup => {
        if (targetDomElement != null && shouldCleanup) {
          (0, _reactDom.unmountComponentAtNode)(targetDomElement);
        }
      };
      const onClose = (theCase, isCreateCase) => {
        const closeModalClickedScenario = theCase == null && !isCreateCase;
        const caseSelectedScenario = theCase != null;
        // When `Creating` a case from the `add to existing case modal`,
        // we close the modal and then open the flyout.
        // If we clean up dom when closing the modal, then the flyout won't open.
        // Thus we do not clean up dom when `Creating` a case.
        const shouldCleanup = closeModalClickedScenario || caseSelectedScenario;
        cleanupDom(shouldCleanup);
      };
      const onSuccess = () => {
        cleanupDom(true);
      };
      const mount = (0, _public3.toMountPoint)( /*#__PURE__*/_react.default.createElement(_action_wrapper.ActionWrapper, {
        core: core,
        caseContextProps: caseContextProps,
        storage: storage,
        plugins: plugins,
        history: history,
        currentAppId: currentAppId
      }, /*#__PURE__*/_react.default.createElement(AddExistingCaseModalWrapper, {
        embeddable: embeddable,
        onClose: onClose,
        onSuccess: onSuccess
      })), {
        theme$: theme.theme$
      });
      mount(targetDomElement);
    }
  });
};
exports.createAddToExistingCaseLensAction = createAddToExistingCaseLensAction;