"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverableUserWithAvatarResolver = void 0;
var _react = _interopRequireDefault(require("react"));
var _hoverable_user_with_avatar = require("./hoverable_user_with_avatar");
var _user_converter = require("./user_converter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HoverableUserWithAvatarResolverComponent = ({
  user,
  userProfiles,
  boldName = true
}) => {
  var _convertToUserInfo;
  const {
    userInfo
  } = (_convertToUserInfo = (0, _user_converter.convertToUserInfo)(user, userProfiles)) !== null && _convertToUserInfo !== void 0 ? _convertToUserInfo : {
    userInfo: undefined
  };
  return /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar.HoverableUserWithAvatar, {
    userInfo: userInfo,
    boldName: boldName
  });
};
HoverableUserWithAvatarResolverComponent.displayName = 'HoverableUserResolver';
const HoverableUserWithAvatarResolver = /*#__PURE__*/_react.default.memo(HoverableUserWithAvatarResolverComponent);
exports.HoverableUserWithAvatarResolver = HoverableUserWithAvatarResolver;