"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleId = exports.createAlertAttachmentUserActionBuilder = void 0;
exports.getRuleInfo = getRuleInfo;
exports.getRuleName = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _timestamp = require("../timestamp");
var _alert_event = require("./alert_event");
var _show_alert = require("./show_alert");
var _show_alert_table_link = require("./show_alert_table_link");
var _hoverable_user_with_avatar_resolver = require("../../user_profiles/hoverable_user_with_avatar_resolver");
var _content_toolbar = require("../content_toolbar");
var _alert_property_actions = require("../property_actions/alert_property_actions");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSingleAlertUserAction = ({
  userAction,
  userProfiles,
  comment,
  alertData,
  loadingAlertData,
  loadingCommentIds,
  getRuleDetailsHref,
  onRuleDetailsClick,
  onShowAlertDetails,
  handleDeleteComment
}) => {
  const alertId = getNonEmptyField(comment.alertId);
  const alertIndex = getNonEmptyField(comment.index);
  if (!alertId || !alertIndex) {
    return [];
  }
  const alertField = alertData[alertId];
  const ruleId = getRuleId(comment, alertField);
  const ruleName = getRuleName(comment, alertField);
  return [{
    username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
      user: userAction.createdBy,
      userProfiles: userProfiles
    }),
    eventColor: 'subdued',
    event: /*#__PURE__*/_react.default.createElement(_alert_event.SingleAlertCommentEvent, {
      actionId: userAction.id,
      getRuleDetailsHref: getRuleDetailsHref,
      loadingAlertData: loadingAlertData,
      onRuleDetailsClick: onRuleDetailsClick,
      ruleId: ruleId,
      ruleName: ruleName
    }),
    'data-test-subj': `user-action-alert-${userAction.type}-${userAction.action}-action-${userAction.id}`,
    timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
      createdAt: userAction.createdAt
    }),
    timelineAvatar: 'bell',
    actions: /*#__PURE__*/_react.default.createElement(_content_toolbar.UserActionContentToolbar, {
      id: comment.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_show_alert.UserActionShowAlert, {
      id: userAction.id,
      alertId: alertId,
      index: alertIndex,
      onShowAlertDetails: onShowAlertDetails
    })), /*#__PURE__*/_react.default.createElement(_alert_property_actions.AlertPropertyActions, {
      onDelete: () => handleDeleteComment(comment.id, (0, _translations.DELETE_ALERTS_SUCCESS_TITLE)(1)),
      isLoading: loadingCommentIds.includes(comment.id),
      totalAlerts: 1
    }))
  }];
};
const getMultipleAlertsUserAction = ({
  userAction,
  userProfiles,
  comment,
  alertData,
  loadingAlertData,
  loadingCommentIds,
  getRuleDetailsHref,
  onRuleDetailsClick,
  handleDeleteComment
}) => {
  if (!Array.isArray(comment.alertId)) {
    return [];
  }
  const totalAlerts = comment.alertId.length;
  const {
    ruleId,
    ruleName
  } = getRuleInfo(comment, alertData);
  return [{
    username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
      user: userAction.createdBy,
      userProfiles: userProfiles
    }),
    eventColor: 'subdued',
    event: /*#__PURE__*/_react.default.createElement(_alert_event.MultipleAlertsCommentEvent, {
      actionId: userAction.id,
      loadingAlertData: loadingAlertData,
      totalAlerts: totalAlerts,
      ruleId: ruleId,
      ruleName: ruleName,
      getRuleDetailsHref: getRuleDetailsHref,
      onRuleDetailsClick: onRuleDetailsClick
    }),
    'data-test-subj': `user-action-alert-${userAction.type}-${userAction.action}-action-${userAction.id}`,
    timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
      createdAt: userAction.createdAt
    }),
    timelineAvatar: 'bell',
    actions: /*#__PURE__*/_react.default.createElement(_content_toolbar.UserActionContentToolbar, {
      id: comment.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_show_alert_table_link.ShowAlertTableLink, null)), /*#__PURE__*/_react.default.createElement(_alert_property_actions.AlertPropertyActions, {
      onDelete: () => handleDeleteComment(comment.id, (0, _translations.DELETE_ALERTS_SUCCESS_TITLE)(totalAlerts)),
      isLoading: loadingCommentIds.includes(comment.id),
      totalAlerts: totalAlerts
    }))
  }];
};
const createAlertAttachmentUserActionBuilder = params => ({
  build: () => {
    const {
      comment
    } = params;
    const alertId = Array.isArray(comment.alertId) ? comment.alertId : [comment.alertId];
    if (alertId.length === 1) {
      return getSingleAlertUserAction(params);
    }
    return getMultipleAlertsUserAction(params);
  }
});
exports.createAlertAttachmentUserActionBuilder = createAlertAttachmentUserActionBuilder;
const getFirstItem = items => {
  return Array.isArray(items) ? items[0] : items !== null && items !== void 0 ? items : null;
};
const getRuleId = (comment, alertData) => {
  var _comment$rule;
  return getRuleField({
    commentRuleField: comment === null || comment === void 0 ? void 0 : (_comment$rule = comment.rule) === null || _comment$rule === void 0 ? void 0 : _comment$rule.id,
    alertData,
    signalRuleFieldPath: 'signal.rule.id',
    kibanaAlertFieldPath: _ruleDataUtils.ALERT_RULE_UUID
  });
};
exports.getRuleId = getRuleId;
const getRuleName = (comment, alertData) => {
  var _comment$rule2;
  return getRuleField({
    commentRuleField: comment === null || comment === void 0 ? void 0 : (_comment$rule2 = comment.rule) === null || _comment$rule2 === void 0 ? void 0 : _comment$rule2.name,
    alertData,
    signalRuleFieldPath: 'signal.rule.name',
    kibanaAlertFieldPath: _ruleDataUtils.ALERT_RULE_NAME
  });
};
exports.getRuleName = getRuleName;
const getRuleField = ({
  commentRuleField,
  alertData,
  signalRuleFieldPath,
  kibanaAlertFieldPath
}) => {
  var _ref, _getNonEmptyField;
  const field = (_ref = (_getNonEmptyField = getNonEmptyField(commentRuleField)) !== null && _getNonEmptyField !== void 0 ? _getNonEmptyField : getNonEmptyField((0, _lodash.get)(alertData, signalRuleFieldPath))) !== null && _ref !== void 0 ? _ref : getNonEmptyField((0, _lodash.get)(alertData, kibanaAlertFieldPath));
  return field;
};
function getNonEmptyField(field) {
  const firstItem = getFirstItem(field);
  if (firstItem == null || (0, _lodash.isEmpty)(firstItem)) {
    return null;
  }
  return firstItem;
}
function getRuleInfo(comment, alertData) {
  const alertId = getNonEmptyField(comment.alertId);
  if (!alertId) {
    return {
      ruleId: null,
      ruleName: null
    };
  }
  const alertField = alertData[alertId];
  const ruleId = getRuleId(comment, alertField);
  const ruleName = getRuleName(comment, alertField);
  return {
    ruleId,
    ruleName
  };
}