"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  CaseCallOut: true
};
exports.CaseCallOut = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _callout = require("./callout");
var _helpers = require("./helpers");
Object.keys(_helpers).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _helpers[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _helpers[key];
    }
  });
});
var _navigation = require("../../../common/navigation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseCallOutComponent = ({
  hasConnectors,
  hasLicenseError,
  onEditClick,
  messages = []
}) => {
  const {
    navigateToConfigureCases
  } = (0, _navigation.useConfigureCasesNavigation)();
  const handleCallOut = (0, _react.useCallback)(e => {
    e.preventDefault();
    // if theres connectors open dropdown editor
    // if no connectors, redirect to create case page
    if (hasConnectors) {
      onEditClick();
    } else {
      navigateToConfigureCases();
    }
  }, [hasConnectors, onEditClick, navigateToConfigureCases]);
  const groupedByTypeErrorMessages = (0, _react.useMemo)(() => messages.reduce((acc, currentMessage) => {
    var _acc$type$messagesId, _acc$type, _acc$type$messages, _acc$type2;
    const type = currentMessage.errorType == null ? 'primary' : currentMessage.errorType;
    return {
      ...acc,
      [type]: {
        messagesId: [...((_acc$type$messagesId = (_acc$type = acc[type]) === null || _acc$type === void 0 ? void 0 : _acc$type.messagesId) !== null && _acc$type$messagesId !== void 0 ? _acc$type$messagesId : []), currentMessage.id],
        messages: [...((_acc$type$messages = (_acc$type2 = acc[type]) === null || _acc$type2 === void 0 ? void 0 : _acc$type2.messages) !== null && _acc$type$messages !== void 0 ? _acc$type$messages : []), currentMessage]
      }
    };
  }, {}), [messages]);
  const groupedByTypeErrorMessagesKeys = Object.keys(groupedByTypeErrorMessages);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupedByTypeErrorMessagesKeys.map((type, index) => {
    const id = (0, _helpers.createCalloutId)(groupedByTypeErrorMessages[type].messagesId);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: id
    }, /*#__PURE__*/_react.default.createElement(_callout.CallOut, {
      handleButtonClick: handleCallOut,
      id: id,
      messages: groupedByTypeErrorMessages[type].messages,
      type: type,
      hasLicenseError: hasLicenseError
    }), index !== groupedByTypeErrorMessagesKeys.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null) : null);
  }));
};
CaseCallOutComponent.displayName = 'CaseCallOut';
const CaseCallOut = /*#__PURE__*/(0, _react.memo)(CaseCallOutComponent);
exports.CaseCallOut = CaseCallOut;