"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severitiesWithAll = exports.severities = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _api = require("../../../common/api");
var _types = require("../../containers/types");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const severities = {
  [_api.CaseSeverity.LOW]: {
    color: _uiTheme.euiLightVars.euiColorVis0,
    label: _translations.LOW
  },
  [_api.CaseSeverity.MEDIUM]: {
    color: _uiTheme.euiLightVars.euiColorVis5,
    label: _translations.MEDIUM
  },
  [_api.CaseSeverity.HIGH]: {
    color: _uiTheme.euiLightVars.euiColorVis7,
    label: _translations.HIGH
  },
  [_api.CaseSeverity.CRITICAL]: {
    color: _uiTheme.euiLightVars.euiColorVis9,
    label: _translations.CRITICAL
  }
};
exports.severities = severities;
const severitiesWithAll = {
  [_types.SeverityAll]: {
    color: 'transparent',
    label: _translations.ALL_SEVERITIES
  },
  ...severities
};
exports.severitiesWithAll = severitiesWithAll;