"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemovableItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RemovableItemComponent = ({
  children,
  tooltipContent,
  buttonAriaLabel,
  onRemoveItem,
  dataTestSubjPrefix = ''
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isHovering, setIsHovering] = (0, _react.useState)(false);
  const onFocus = () => setIsHovering(true);
  const onFocusLeave = () => setIsHovering(false);
  const dataTestSubj = dataTestSubjPrefix.length > 0 ? `${dataTestSubjPrefix}-remove-` : 'remove-';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "spaceBetween",
    onMouseEnter: onFocus,
    onMouseLeave: onFocusLeave,
    "data-test-subj": `${dataTestSubj}group`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, children), permissions.update && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: tooltipContent,
    "data-test-subj": `${dataTestSubj}tooltip`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    css: {
      opacity: isHovering ? 1 : 0
    },
    onFocus: onFocus,
    onBlur: onFocusLeave,
    "data-test-subj": `${dataTestSubj}button`,
    "aria-label": buttonAriaLabel,
    iconType: "cross",
    color: "danger",
    iconSize: "m",
    onClick: onRemoveItem
  }))));
};
RemovableItemComponent.displayName = 'RemovableItem';
const RemovableItem = /*#__PURE__*/_react.default.memo(RemovableItemComponent);
exports.RemovableItem = RemovableItem;