"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _markdown_link = require("./markdown_link");
var _use_plugins = require("./use_plugins");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const withDisabledLinks = disableLinks => {
  const MarkdownLinkProcessingComponent = /*#__PURE__*/(0, _react.memo)(props => /*#__PURE__*/_react.default.createElement(_markdown_link.MarkdownLink, (0, _extends2.default)({}, props, {
    disableLinks: disableLinks
  })));
  MarkdownLinkProcessingComponent.displayName = 'MarkdownLinkProcessingComponent';
  return MarkdownLinkProcessingComponent;
};
const MarkdownRendererComponent = ({
  children,
  disableLinks,
  textSize
}) => {
  const {
    processingPlugins,
    parsingPlugins
  } = (0, _use_plugins.usePlugins)();
  // Deep clone of the processing plugins to prevent affecting the markdown editor.
  const processingPluginList = (0, _fp.cloneDeep)(processingPlugins);
  // This line of code is TS-compatible and it will break if [1][1] change in the future.
  processingPluginList[1][1].components.a = (0, _react.useMemo)(() => withDisabledLinks(disableLinks), [disableLinks]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    parsingPluginList: parsingPlugins,
    processingPluginList: processingPluginList,
    grow: true,
    textSize: textSize
  }, children);
};
MarkdownRendererComponent.displayName = 'MarkdownRenderer';
const MarkdownRenderer = /*#__PURE__*/(0, _react.memo)(MarkdownRendererComponent);
exports.MarkdownRenderer = MarkdownRenderer;