"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsForm = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _api = require("../../../common/api");
var _fields_form = require("../connectors/fields_form");
var _utils = require("../utils");
var _form = require("../connector_selector/form");
var _utils2 = require("../configure_cases/utils");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorsFormComponent = ({
  caseData,
  caseConnectors,
  supportedActionConnectors,
  isLoading,
  onSubmit,
  onCancel
}) => {
  const initialConnectorId = caseData.connector.id;
  const initialConnectorFields = caseData.connector.fields;
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      connectorId: initialConnectorId,
      fields: initialConnectorFields
    },
    options: {
      stripEmptyFields: false
    },
    serializer: _utils.getConnectorsFormSerializer,
    deserializer: _utils.getConnectorsFormDeserializer
  });
  const [{
    connectorId,
    fields
  }] = (0, _hook_form_lib.useFormData)({
    form
  });
  const fieldsWithNullValues = (0, _react.useMemo)(() => (0, _utils.convertEmptyValuesToNull)(fields), [fields]);
  const {
    submit
  } = form;
  const currentActionConnector = (0, _utils.getConnectorById)(connectorId, supportedActionConnectors);

  /**
   *  only enable the save button if changes were made to the previous selected
   * connector or its fields
   * null and none are equivalent to `no connector`.
   * This makes sure we don't enable the button when the "no connector" option is selected
   * by default. e.g. when a case is created without a connector
   */
  const isDefaultNoneConnectorSelected = currentActionConnector === null && initialConnectorId === _api.NONE_CONNECTOR_ID;
  const enableSave = !isDefaultNoneConnectorSelected && (currentActionConnector === null || currentActionConnector === void 0 ? void 0 : currentActionConnector.id) !== initialConnectorId || !(0, _fastDeepEqual.default)(fieldsWithNullValues, initialConnectorFields);
  const onConnectorChange = newConnectorId => {
    var _caseConnectors$newCo;
    const newFields = (_caseConnectors$newCo = caseConnectors[newConnectorId]) === null || _caseConnectors$newCo === void 0 ? void 0 : _caseConnectors$newCo.fields;
    form.reset({
      resetValues: true,
      defaultValue: {
        connectorId: newConnectorId,
        fields: newFields
      }
    });
  };
  const connectorIdConfig = (0, _utils.getConnectorsFormValidators)({
    config: {},
    connectors: supportedActionConnectors
  });
  const onSubmitConnector = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data: newData
    } = await submit();
    if (isValid && newData.connectorId) {
      var _newData$fields;
      const connector = (0, _utils.getConnectorById)(newData.connectorId, supportedActionConnectors);
      const connectorToUpdate = connector ? (0, _utils2.normalizeActionConnector)(connector) : (0, _utils2.getNoneConnector)();
      const connectorWithFields = {
        ...connectorToUpdate,
        fields: (_newData$fields = newData.fields) !== null && _newData$fields !== void 0 ? _newData$fields : null
      };
      onSubmit(connectorWithFields);
    }
  }, [onSubmit, submit, supportedActionConnectors]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "connectorId",
    config: connectorIdConfig,
    component: _form.ConnectorSelector,
    componentProps: {
      connectors: supportedActionConnectors,
      dataTestSubj: 'caseConnectors',
      defaultValue: initialConnectorId,
      idAria: 'caseConnectors',
      isLoading,
      handleChange: onConnectorChange
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "edit-connector-fields-form-flex-item"
  }, /*#__PURE__*/_react.default.createElement(_fields_form.ConnectorFieldsForm, {
    connector: currentActionConnector,
    key: connectorId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !enableSave,
    color: "success",
    "data-test-subj": "edit-connectors-submit",
    fill: true,
    iconType: "save",
    onClick: onSubmitConnector,
    size: "s"
  }, i18n.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "edit-connectors-cancel",
    iconType: "cross",
    onClick: onCancel,
    size: "s"
  }, i18n.CANCEL))))));
};
ConnectorsFormComponent.displayName = 'ConnectorsForm';
const ConnectorsForm = /*#__PURE__*/_react.default.memo(ConnectorsFormComponent);
exports.ConnectorsForm = ConnectorsForm;