"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _schema = require("./schema");
var _utils = require("../configure_cases/utils");
var _use_post_case = require("../../containers/use_post_case");
var _use_post_push_to_service = require("../../containers/use_post_push_to_service");
var _api = require("../../../common/api");
var _use_create_attachments = require("../../containers/use_create_attachments");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cases_features = require("../../common/use_cases_features");
var _utils2 = require("../utils");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _use_cases_transactions = require("../../common/apm/use_cases_transactions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialCaseValue = {
  description: '',
  tags: [],
  title: '',
  severity: _api.CaseSeverity.LOW,
  connectorId: _api.NONE_CONNECTOR_ID,
  fields: null,
  syncAlerts: true,
  selectedOwner: null,
  assignees: []
};
const FormContext = ({
  afterCaseCreated,
  children,
  onSuccess,
  attachments,
  initialValue
}) => {
  const {
    data: connectors = [],
    isLoading: isLoadingConnectors
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const {
    owner,
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const {
    isSyncAlertsEnabled
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    mutateAsync: postCase
  } = (0, _use_post_case.usePostCase)();
  const {
    mutateAsync: createAttachments
  } = (0, _use_create_attachments.useCreateAttachments)();
  const {
    mutateAsync: pushCaseToExternalService
  } = (0, _use_post_push_to_service.usePostPushToService)();
  const {
    startTransaction
  } = (0, _use_cases_transactions.useCreateCaseWithAttachmentsTransaction)();
  const submitCase = (0, _react.useCallback)(async ({
    connectorId: dataConnectorId,
    fields,
    syncAlerts = isSyncAlertsEnabled,
    ...dataWithoutConnectorId
  }, isValid) => {
    if (isValid) {
      const {
        selectedOwner,
        ...userFormData
      } = dataWithoutConnectorId;
      const caseConnector = (0, _utils2.getConnectorById)(dataConnectorId, connectors);
      startTransaction({
        appId,
        attachments
      });
      const connectorToUpdate = caseConnector ? (0, _utils.normalizeActionConnector)(caseConnector, fields) : (0, _utils.getNoneConnector)();
      const theCase = await postCase({
        request: {
          ...userFormData,
          connector: connectorToUpdate,
          settings: {
            syncAlerts
          },
          owner: selectedOwner !== null && selectedOwner !== void 0 ? selectedOwner : owner[0]
        }
      });

      // add attachments to the case
      if (theCase && Array.isArray(attachments) && attachments.length > 0) {
        await createAttachments({
          caseId: theCase.id,
          caseOwner: theCase.owner,
          attachments
        });
      }
      if (afterCaseCreated && theCase) {
        await afterCaseCreated(theCase, createAttachments);
      }
      if (theCase !== null && theCase !== void 0 && theCase.id && connectorToUpdate.id !== 'none') {
        await pushCaseToExternalService({
          caseId: theCase.id,
          connector: connectorToUpdate
        });
      }
      if (onSuccess && theCase) {
        onSuccess(theCase);
      }
    }
  }, [isSyncAlertsEnabled, connectors, startTransaction, appId, attachments, postCase, owner, afterCaseCreated, onSuccess, createAttachments, pushCaseToExternalService]);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      ...initialCaseValue,
      ...initialValue
    },
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema,
    onSubmit: submitCase,
    serializer: _utils2.getConnectorsFormSerializer,
    deserializer: _utils2.getConnectorsFormDeserializer
  });
  const childrenWithExtraProp = (0, _react.useMemo)(() => children != null ? _react.default.Children.map(children, child => /*#__PURE__*/_react.default.cloneElement(child, {
    connectors,
    isLoadingConnectors
  })) : null, [children, connectors, isLoadingConnectors]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    onKeyDown: e => {
      // It avoids the focus scaping from the flyout when enter is pressed.
      // https://github.com/elastic/kibana/issues/111120
      if (e.key === 'Enter') {
        e.stopPropagation();
      }
    },
    form: form
  }, childrenWithExtraProp);
};
exports.FormContext = FormContext;
FormContext.displayName = 'FormContext';