"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("../translations"));
var _form = require("../form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledFlyout = (0, _styledComponents.default)(_eui.EuiFlyout)`
  ${({
  theme
}) => `
      z-index: ${theme.eui.euiZModal};
    `}
`;

// Adding bottom padding because timeline's
// bottom bar gonna hide the submit button.
const StyledEuiFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  ${({
  theme
}) => `
      && .euiFlyoutBody__overflow {
        overflow-y: auto;
        overflow-x: hidden;
      }

      && .euiFlyoutBody__overflowContent {
        display: block;
        padding: ${theme.eui.euiSizeL} ${theme.eui.euiSizeL} 70px;
        height: auto;
      }
    `}
`;
const FormWrapper = _styledComponents.default.div`
  width: 100%;
`;
const CreateCaseFlyout = /*#__PURE__*/_react.default.memo(({
  afterCaseCreated,
  attachments,
  headerContent,
  initialValue,
  onClose,
  onSuccess
}) => {
  const handleCancel = onClose || _lodash.noop;
  const handleOnSuccess = onSuccess || _lodash.noop;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  }), /*#__PURE__*/_react.default.createElement(StyledFlyout, {
    onClose: onClose,
    "tour-step": "create-case-flyout",
    "data-test-subj": "create-case-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    "data-test-subj": "create-case-flyout-header",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, i18n.CREATE_CASE_TITLE)), headerContent && headerContent), /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(FormWrapper, null, /*#__PURE__*/_react.default.createElement(_form.CreateCaseForm, {
    afterCaseCreated: afterCaseCreated,
    attachments: attachments,
    onCancel: handleCancel,
    onSuccess: handleOnSuccess,
    withSteps: false,
    initialValue: initialValue
  })))));
});
exports.CreateCaseFlyout = CreateCaseFlyout;
CreateCaseFlyout.displayName = 'CreateCaseFlyout';