"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldName = exports.Description = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _markdown_editor = require("../markdown_editor");
var _constants = require("../markdown_editor/plugins/lens/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldName = 'description';
exports.fieldName = fieldName;
const DescriptionComponent = ({
  isLoading,
  draftStorageKey
}) => {
  const [{
    title,
    tags
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['title', 'tags']
  });
  const editorRef = (0, _react.useRef)();
  const disabledUiPlugins = [_constants.ID];
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: fieldName,
    component: _markdown_editor.MarkdownEditorForm,
    componentProps: {
      id: fieldName,
      ref: editorRef,
      dataTestSubj: 'caseDescription',
      idAria: 'caseDescription',
      isDisabled: isLoading,
      caseTitle: title,
      caseTags: tags,
      disabledUiPlugins,
      draftStorageKey
    }
  });
};
DescriptionComponent.displayName = 'DescriptionComponent';
const Description = /*#__PURE__*/(0, _react.memo)(DescriptionComponent);
exports.Description = Description;