"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAnyRequiredFieldNotSet = exports.connectorValidator = void 0;
var _api = require("../../../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const casesRequiredFields = ['caseIdConfig', 'caseNameConfig', 'descriptionConfig', 'commentsConfig'];
const isAnyRequiredFieldNotSet = mapping => casesRequiredFields.some(field => (mapping === null || mapping === void 0 ? void 0 : mapping[field]) == null);

/**
 * The user can use either a connector of type cases or all.
 * If the connector is of type all we should check if all
 * required field have been configured.
 */
exports.isAnyRequiredFieldNotSet = isAnyRequiredFieldNotSet;
const connectorValidator = connector => {
  const config = connector.config;
  if (config == null) {
    return;
  }
  if (config.connectorType === _api.SwimlaneConnectorType.Alerts || isAnyRequiredFieldNotSet(config.mappings)) {
    return {
      message: 'Invalid connector'
    };
  }
};
exports.connectorValidator = connectorValidator;