"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _api = require("../../../../common/api");
var _kibana = require("../../../common/lib/kibana");
var _card = require("../card");
var _use_get_choices = require("./use_get_choices");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _deprecated_callout = require("../deprecated_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const choicesToGet = ['category', 'subcategory', 'priority'];
const defaultFields = {
  category: [],
  subcategory: [],
  priority: []
};
const ServiceNowSIRFieldsPreviewComponent = ({
  connector,
  fields
}) => {
  var _choicesData$data;
  const {
    category = null,
    destIp = true,
    malwareHash = true,
    malwareUrl = true,
    priority = null,
    sourceIp = true,
    subcategory = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const showConnectorWarning = connector.isDeprecated;
  const {
    isLoading,
    isFetching,
    data: choicesData
  } = (0, _use_get_choices.useGetChoices)({
    http,
    connector,
    fields: choicesToGet
  });
  const choices = (_choicesData$data = choicesData === null || choicesData === void 0 ? void 0 : choicesData.data) !== null && _choicesData$data !== void 0 ? _choicesData$data : [];
  const isLoadingChoices = isLoading || isFetching;
  const choicesFormatted = choices.reduce((acc, value) => ({
    ...acc,
    [value.element]: [...(acc[value.element] != null ? acc[value.element] : []), value]
  }), defaultFields);
  const categoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.category), [choicesFormatted.category]);
  const priorityOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.priority), [choicesFormatted.priority]);
  const subcategoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.subcategory.filter(choice => choice.dependent_value === category)), [choicesFormatted.subcategory, category]);
  const listItems = (0, _react.useMemo)(() => {
    var _priorityOptions$find, _categoryOptions$find, _subcategoryOptions$f;
    return [...(destIp != null && destIp ? [{
      title: i18n.DEST_IP,
      description: i18n.ALERT_FIELD_ENABLED_TEXT
    }] : []), ...(sourceIp != null && sourceIp ? [{
      title: i18n.SOURCE_IP,
      description: i18n.ALERT_FIELD_ENABLED_TEXT
    }] : []), ...(malwareUrl != null && malwareUrl ? [{
      title: i18n.MALWARE_URL,
      description: i18n.ALERT_FIELD_ENABLED_TEXT
    }] : []), ...(malwareHash != null && malwareHash ? [{
      title: i18n.MALWARE_HASH,
      description: i18n.ALERT_FIELD_ENABLED_TEXT
    }] : []), ...(priority != null && priority.length > 0 ? [{
      title: i18n.PRIORITY,
      description: (_priorityOptions$find = priorityOptions.find(option => `${option.value}` === priority)) === null || _priorityOptions$find === void 0 ? void 0 : _priorityOptions$find.text
    }] : []), ...(category != null && category.length > 0 ? [{
      title: i18n.CATEGORY,
      description: (_categoryOptions$find = categoryOptions.find(option => `${option.value}` === category)) === null || _categoryOptions$find === void 0 ? void 0 : _categoryOptions$find.text
    }] : []), ...(subcategory != null && subcategory.length > 0 ? [{
      title: i18n.SUBCATEGORY,
      description: (_subcategoryOptions$f = subcategoryOptions.find(option => `${option.value}` === subcategory)) === null || _subcategoryOptions$f === void 0 ? void 0 : _subcategoryOptions$f.text
    }] : [])];
  }, [category, categoryOptions, destIp, malwareHash, malwareUrl, priority, priorityOptions, sourceIp, subcategory, subcategoryOptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConnectorWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _api.ConnectorTypes.serviceNowSIR,
    title: connector.name,
    listItems: listItems,
    isLoading: isLoadingChoices
  }))));
};
exports.default = ServiceNowSIRFieldsPreviewComponent;
ServiceNowSIRFieldsPreviewComponent.displayName = 'ServiceNowSIRFieldsPreviewComponent';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;