"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE_ACTION_API_PATH = void 0;
exports.getIncidentTypes = getIncidentTypes;
exports.getSeverity = getSeverity;
var _connectors_api = require("../../../../common/utils/connectors_api");
var _rewrite_response_to_camel_case = require("../rewrite_response_to_camel_case");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_ACTION_API_PATH = '/api/actions';
exports.BASE_ACTION_API_PATH = BASE_ACTION_API_PATH;
async function getIncidentTypes({
  http,
  connectorId,
  signal
}) {
  const res = await http.post((0, _connectors_api.getExecuteConnectorUrl)(connectorId), {
    body: JSON.stringify({
      params: {
        subAction: 'incidentTypes',
        subActionParams: {}
      }
    }),
    signal
  });
  return (0, _rewrite_response_to_camel_case.rewriteResponseToCamelCase)(res);
}
async function getSeverity({
  http,
  connectorId,
  signal
}) {
  const res = await http.post((0, _connectors_api.getExecuteConnectorUrl)(connectorId), {
    body: JSON.stringify({
      params: {
        subAction: 'severity',
        subActionParams: {}
      }
    }),
    signal
  });
  return (0, _rewrite_response_to_camel_case.rewriteResponseToCamelCase)(res);
}