"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldsByIssueType = getFieldsByIssueType;
exports.getIssue = getIssue;
exports.getIssueTypes = getIssueTypes;
exports.getIssues = getIssues;
var _utils = require("../../../../common/utils");
var _rewrite_response_to_camel_case = require("../rewrite_response_to_camel_case");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIssueTypes({
  http,
  connectorId,
  signal
}) {
  const res = await http.post((0, _utils.getExecuteConnectorUrl)(connectorId), {
    body: JSON.stringify({
      params: {
        subAction: 'issueTypes',
        subActionParams: {}
      }
    }),
    signal
  });
  return (0, _rewrite_response_to_camel_case.rewriteResponseToCamelCase)(res);
}
async function getFieldsByIssueType({
  http,
  connectorId,
  id,
  signal
}) {
  const res = await http.post((0, _utils.getExecuteConnectorUrl)(connectorId), {
    body: JSON.stringify({
      params: {
        subAction: 'fieldsByIssueType',
        subActionParams: {
          id
        }
      }
    }),
    signal
  });
  return (0, _rewrite_response_to_camel_case.rewriteResponseToCamelCase)(res);
}
async function getIssues({
  http,
  connectorId,
  title,
  signal
}) {
  const res = await http.post((0, _utils.getExecuteConnectorUrl)(connectorId), {
    body: JSON.stringify({
      params: {
        subAction: 'issues',
        subActionParams: {
          title
        }
      }
    }),
    signal
  });
  return (0, _rewrite_response_to_camel_case.rewriteResponseToCamelCase)(res);
}
async function getIssue({
  http,
  connectorId,
  id,
  signal
}) {
  const res = await http.post((0, _utils.getExecuteConnectorUrl)(connectorId), {
    body: JSON.stringify({
      params: {
        subAction: 'issue',
        subActionParams: {
          id
        }
      }
    }),
    signal
  });
  return (0, _rewrite_response_to_camel_case.rewriteResponseToCamelCase)(res);
}