"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldMapping = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _field_mapping_row_static = require("./field_mapping_row_static");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldRowWrapper = _styledComponents.default.div`
  margin: 10px 0;
  font-size: 14px;
`;
const FieldMappingComponent = ({
  actionTypeName,
  isLoading,
  mappings
}) => {
  return mappings.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", {
    className: "euiFormLabel"
  }, i18n.FIELD_MAPPING_FIRST_COL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-configure-field-mappings-second-col-label"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "euiFormLabel"
  }, i18n.FIELD_MAPPING_SECOND_COL(actionTypeName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", {
    className: "euiFormLabel"
  }, i18n.FIELD_MAPPING_THIRD_COL)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FieldRowWrapper, {
    "data-test-subj": "case-configure-field-mappings-row-wrapper"
  }, mappings.map(item => {
    var _item$target;
    return /*#__PURE__*/_react.default.createElement(_field_mapping_row_static.FieldMappingRowStatic, {
      key: `${item.source}`,
      casesField: item.source,
      isLoading: isLoading,
      selectedActionType: item.actionType,
      selectedThirdParty: (_item$target = item.target) !== null && _item$target !== void 0 ? _item$target : 'not_mapped'
    });
  })))) : null;
};
FieldMappingComponent.displayName = 'FieldMapping';
const FieldMapping = /*#__PURE__*/_react.default.memo(FieldMappingComponent);
exports.FieldMapping = FieldMapping;