"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryFormField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../common/constants");
var _category_component = require("./category_component");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCategoryConfig = () => ({
  defaultValue: null,
  validations: [{
    validator: ({
      value
    }) => {
      if (value == null) {
        return;
      }
      if ((0, _lodash.isEmpty)(value.trim())) {
        return {
          message: _translations.EMPTY_CATEGORY_VALIDATION_MSG
        };
      }
    }
  }, {
    validator: ({
      value
    }) => {
      if (value == null) {
        return;
      }
      if (value.length > _constants.MAX_CATEGORY_LENGTH) {
        return {
          message: (0, _translations.MAX_LENGTH_ERROR)('category', _constants.MAX_CATEGORY_LENGTH)
        };
      }
    }
  }]
});
const CategoryFormFieldComponent = ({
  isLoading,
  availableCategories,
  formRowProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: 'category',
    config: getCategoryConfig()
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onChange = category => {
      field.setValue(category);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, formRowProps, {
      label: _translations.CATEGORY,
      error: errorMessage,
      isInvalid: isInvalid,
      fullWidth: true
    }), /*#__PURE__*/_react.default.createElement(_category_component.CategoryComponent, {
      isLoading: isLoading,
      onChange: onChange,
      category: field.value,
      availableCategories: availableCategories,
      isInvalid: isInvalid
    }));
  });
};
CategoryFormFieldComponent.displayName = 'CategoryFormFieldComponent';
const CategoryFormField = /*#__PURE__*/(0, _react.memo)(CategoryFormFieldComponent);
exports.CategoryFormField = CategoryFormField;