"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewMetricItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseViewMetricItems = /*#__PURE__*/_react.default.memo(({
  metrics,
  features
}) => {
  const metricItems = useGetTitleValueMetricItems(metrics, features);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, metricItems.map(({
    id,
    title,
    value
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: title,
    "data-test-subj": `case-metrics-totals-${id}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, title), /*#__PURE__*/_react.default.createElement(MetricValue, null, value)))));
});
exports.CaseViewMetricItems = CaseViewMetricItems;
CaseViewMetricItems.displayName = 'CaseViewMetricItems';
const MetricValue = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  font-size: ${({
  theme
}) => theme.eui.euiSizeL};
  font-weight: bold;
`;
const useGetTitleValueMetricItems = (metrics, features) => {
  var _connectors$total, _alerts$count, _alerts$users$total, _alerts$users, _alerts$hosts$total, _alerts$hosts;
  const {
    alerts,
    actions,
    connectors
  } = metrics !== null && metrics !== void 0 ? metrics : {};
  const totalConnectors = (_connectors$total = connectors === null || connectors === void 0 ? void 0 : connectors.total) !== null && _connectors$total !== void 0 ? _connectors$total : 0;
  const alertsCount = (_alerts$count = alerts === null || alerts === void 0 ? void 0 : alerts.count) !== null && _alerts$count !== void 0 ? _alerts$count : 0;
  const totalAlertUsers = (_alerts$users$total = alerts === null || alerts === void 0 ? void 0 : (_alerts$users = alerts.users) === null || _alerts$users === void 0 ? void 0 : _alerts$users.total) !== null && _alerts$users$total !== void 0 ? _alerts$users$total : 0;
  const totalAlertHosts = (_alerts$hosts$total = alerts === null || alerts === void 0 ? void 0 : (_alerts$hosts = alerts.hosts) === null || _alerts$hosts === void 0 ? void 0 : _alerts$hosts.total) !== null && _alerts$hosts$total !== void 0 ? _alerts$hosts$total : 0;
  const totalIsolatedHosts = calculateTotalIsolatedHosts(actions);
  const metricItems = (0, _react.useMemo)(() => {
    const items = [['alerts.count', {
      title: _translations.TOTAL_ALERTS_METRIC,
      value: alertsCount
    }], ['alerts.users', {
      title: _translations.ASSOCIATED_USERS_METRIC,
      value: totalAlertUsers
    }], ['alerts.hosts', {
      title: _translations.ASSOCIATED_HOSTS_METRIC,
      value: totalAlertHosts
    }], ['actions.isolateHost', {
      title: _translations.ISOLATED_HOSTS_METRIC,
      value: totalIsolatedHosts
    }], ['connectors', {
      title: _translations.TOTAL_CONNECTORS_METRIC,
      value: totalConnectors
    }]];
    return items.reduce((result, [feature, item]) => [...result, ...(features.includes(feature) ? [{
      id: feature,
      ...item
    }] : [])], []);
  }, [features, alertsCount, totalAlertUsers, totalAlertHosts, totalIsolatedHosts, totalConnectors]);
  return metricItems;
};
const calculateTotalIsolatedHosts = actions => {
  if (!(actions !== null && actions !== void 0 && actions.isolateHost)) {
    return 0;
  }

  // prevent the metric from being negative
  return Math.max(actions.isolateHost.isolate.total - actions.isolateHost.unisolate.total, 0);
};