"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _get_cases = require("../../client/ui/get_cases");
var _kibana = require("../../common/lib/kibana");
var _wrappers = require("../wrappers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CasesAppComponent = ({
  externalReferenceAttachmentTypeRegistry,
  persistableStateAttachmentTypeRegistry,
  getFilesClient
}) => {
  const userCapabilities = (0, _kibana.useApplicationCapabilities)();
  return /*#__PURE__*/_react.default.createElement(_wrappers.Wrapper, {
    "data-test-subj": "cases-app"
  }, (0, _get_cases.getCasesLazy)({
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry,
    getFilesClient,
    owner: [_constants.APP_OWNER],
    useFetchAlertData: () => [false, {}],
    permissions: userCapabilities.generalCases,
    basePath: '/',
    features: {
      alerts: {
        enabled: false
      }
    },
    releasePhase: 'experimental'
  }));
};
CasesAppComponent.displayName = 'CasesApp';
const CasesApp = /*#__PURE__*/_react.default.memo(CasesAppComponent);
exports.CasesApp = CasesApp;