"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesColumns = exports.ExternalServiceColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _services = require("@elastic/eui/lib/services");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _status = require("@kbn/cases-components/src/status/status");
var _common = require("@kbn/kibana-react-plugin/common");
var _api = require("../../../common/api");
var _constants = require("../../../common/constants");
var _empty_value = require("../empty_value");
var _formatted_date = require("../formatted_date");
var _links = require("../links");
var i18n = _interopRequireWildcard(require("./translations"));
var _translations2 = require("../../common/translations");
var _use_actions = require("./use_actions");
var _kibana = require("../../common/lib/kibana");
var _truncated_text = require("../truncated_text");
var _utils = require("../utils");
var _config = require("../severity/config");
var _use_cases_features = require("../../common/use_cases_features");
var _assignees_column = require("./assignees_column");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LINE_CLAMP = 3;
const LineClampedEuiBadgeGroup = (0, _common.euiStyled)(_eui.EuiBadgeGroup)`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: ${LINE_CLAMP};
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: normal;
`;

// margin-right is required here because -webkit-box-orient: vertical;
// in the EuiBadgeGroup prevents us from defining gutterSize.
const StyledEuiBadge = (0, _common.euiStyled)(_eui.EuiBadge)`
  max-width: 100px;
  margin-right: 5px;
`; // to allow for ellipsis

const renderStringField = (field, dataTestSubj) => field != null ? /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": dataTestSubj
}, field) : (0, _empty_value.getEmptyTagValue)();
const useCasesColumns = ({
  filterStatus,
  userProfiles,
  isSelectorView,
  connectors = [],
  onRowClick,
  showSolutionColumn,
  disableActions = false
}) => {
  const {
    isAlertsEnabled,
    caseAssignmentAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    actions
  } = (0, _use_actions.useActions)({
    disableActions
  });
  const assignCaseAction = (0, _react.useCallback)(async theCase => {
    if (onRowClick) {
      onRowClick(theCase);
    }
  }, [onRowClick]);
  const columns = [{
    field: 'title',
    name: i18n.NAME,
    sortable: true,
    render: (title, theCase) => {
      if (theCase.id != null && theCase.title != null) {
        const caseDetailsLinkComponent = isSelectorView ? theCase.title : /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
          detailName: theCase.id,
          title: theCase.title
        }, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
          text: theCase.title
        }));
        return caseDetailsLinkComponent;
      }
      return (0, _empty_value.getEmptyTagValue)();
    },
    width: !isSelectorView ? '20%' : '55%'
  }];
  if (caseAssignmentAuthorized && !isSelectorView) {
    columns.push({
      field: 'assignees',
      name: i18n.ASSIGNEES,
      render: assignees => /*#__PURE__*/_react.default.createElement(_assignees_column.AssigneesColumn, {
        assignees: assignees,
        userProfiles: userProfiles
      }),
      width: '180px'
    });
  }
  if (!isSelectorView) {
    columns.push({
      field: 'tags',
      name: i18n.TAGS,
      render: tags => {
        if (tags != null && tags.length > 0) {
          const clampedBadges = /*#__PURE__*/_react.default.createElement(LineClampedEuiBadgeGroup, {
            "data-test-subj": "case-table-column-tags"
          }, tags.map((tag, i) => /*#__PURE__*/_react.default.createElement(StyledEuiBadge, {
            color: "hollow",
            key: `${tag}-${i}`,
            "data-test-subj": `case-table-column-tags-${tag}`
          }, tag)));
          const unclampedBadges = /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
            "data-test-subj": "case-table-column-tags"
          }, tags.map((tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: "hollow",
            key: `${tag}-${i}`,
            "data-test-subj": `case-table-column-tags-${tag}`
          }, tag)));
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            "data-test-subj": "case-table-column-tags-tooltip",
            position: "left",
            content: unclampedBadges
          }, clampedBadges);
        }
        return (0, _empty_value.getEmptyTagValue)();
      },
      width: '15%'
    });
  }
  if (isAlertsEnabled && !isSelectorView) {
    columns.push({
      align: _services.RIGHT_ALIGNMENT,
      field: 'totalAlerts',
      name: _translations2.ALERTS,
      render: totalAlerts => totalAlerts != null ? renderStringField(`${totalAlerts}`, `case-table-column-alertsCount`) : (0, _empty_value.getEmptyTagValue)(),
      width: !isSelectorView ? '80px' : '55px'
    });
  }
  if (showSolutionColumn && !isSelectorView) {
    columns.push({
      align: _services.RIGHT_ALIGNMENT,
      field: 'owner',
      name: i18n.SOLUTION,
      render: caseOwner => {
        const ownerInfo = _constants.OWNER_INFO[caseOwner];
        return ownerInfo ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: ownerInfo.iconType,
          title: ownerInfo.label,
          "data-test-subj": `case-table-column-owner-icon-${caseOwner}`
        }) : (0, _empty_value.getEmptyTagValue)();
      }
    });
  }
  if (!isSelectorView) {
    columns.push({
      align: _services.RIGHT_ALIGNMENT,
      field: 'totalComment',
      name: i18n.COMMENTS,
      render: totalComment => totalComment != null ? renderStringField(`${totalComment}`, `case-table-column-commentCount`) : (0, _empty_value.getEmptyTagValue)()
    });
  }
  columns.push({
    field: 'category',
    name: i18n.CATEGORY,
    sortable: true,
    render: category => {
      if (category != null) {
        return category;
      }
      return (0, _empty_value.getEmptyTagValue)();
    },
    width: '100px'
  });
  if (filterStatus === _api.CaseStatuses.closed) {
    columns.push({
      field: 'closedAt',
      name: i18n.CLOSED_ON,
      sortable: true,
      render: closedAt => {
        if (closedAt != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": `case-table-column-closedAt`
          }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: closedAt
          }));
        }
        return (0, _empty_value.getEmptyTagValue)();
      }
    });
  } else {
    columns.push({
      field: 'createdAt',
      name: i18n.CREATED_ON,
      sortable: true,
      render: createdAt => {
        if (createdAt != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": `case-table-column-createdAt`
          }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: createdAt,
            stripMs: true
          }));
        }
        return (0, _empty_value.getEmptyTagValue)();
      }
    });
  }
  if (!isSelectorView) {
    columns.push({
      field: 'updatedAt',
      name: i18n.UPDATED_ON,
      sortable: true,
      render: updatedAt => {
        if (updatedAt != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": "case-table-column-updatedAt"
          }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: updatedAt,
            stripMs: true
          }));
        }
        return (0, _empty_value.getEmptyTagValue)();
      }
    });
  }
  if (!isSelectorView) {
    columns.push({
      name: i18n.EXTERNAL_INCIDENT,
      render: theCase => {
        if (theCase.id != null) {
          return /*#__PURE__*/_react.default.createElement(ExternalServiceColumn, {
            theCase: theCase,
            connectors: connectors
          });
        }
        return (0, _empty_value.getEmptyTagValue)();
      },
      width: isSelectorView ? '80px' : undefined
    }, {
      field: 'status',
      name: i18n.STATUS,
      sortable: true,
      render: status => {
        if (status != null) {
          return /*#__PURE__*/_react.default.createElement(_status.Status, {
            status: status
          });
        }
        return (0, _empty_value.getEmptyTagValue)();
      }
    });
  }
  columns.push({
    field: 'severity',
    name: i18n.SEVERITY,
    sortable: true,
    render: severity => {
      if (severity != null) {
        const severityData = _config.severities[severity !== null && severity !== void 0 ? severity : _api.CaseSeverity.LOW];
        return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          "data-test-subj": `case-table-column-severity-${severity}`,
          color: severityData.color
        }, severityData.label);
      }
      return (0, _empty_value.getEmptyTagValue)();
    },
    width: '90px'
  });
  if (isSelectorView) {
    columns.push({
      align: _services.RIGHT_ALIGNMENT,
      render: theCase => {
        if (theCase.id != null) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            "data-test-subj": `cases-table-row-select-${theCase.id}`,
            onClick: () => {
              assignCaseAction(theCase);
            },
            size: "s"
          }, i18n.SELECT);
        }
        return (0, _empty_value.getEmptyTagValue)();
      }
    });
  }
  if (!isSelectorView && actions) {
    columns.push(actions);
  }
  return {
    columns
  };
};
exports.useCasesColumns = useCasesColumns;
const IconWrapper = _styledComponents.default.span`
  svg {
    height: 20px !important;
    position: relative;
    top: 3px;
    width: 20px !important;
  }
`;
const ExternalServiceColumn = ({
  theCase,
  connectors
}) => {
  var _theCase$externalServ2, _theCase$externalServ3, _theCase$externalServ4, _theCase$externalServ5, _theCase$externalServ6, _theCase$externalServ7, _theCase$externalServ8;
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  if (theCase.externalService == null) {
    return renderStringField(i18n.NOT_PUSHED, `case-table-column-external-notPushed`);
  }
  const lastPushedConnector = connectors.find(connector => {
    var _theCase$externalServ;
    return connector.id === ((_theCase$externalServ = theCase.externalService) === null || _theCase$externalServ === void 0 ? void 0 : _theCase$externalServ.connectorId);
  });
  const lastCaseUpdate = theCase.updatedAt != null ? new Date(theCase.updatedAt) : null;
  const lastCasePush = ((_theCase$externalServ2 = theCase.externalService) === null || _theCase$externalServ2 === void 0 ? void 0 : _theCase$externalServ2.pushedAt) != null ? new Date((_theCase$externalServ3 = theCase.externalService) === null || _theCase$externalServ3 === void 0 ? void 0 : _theCase$externalServ3.pushedAt) : null;
  const hasDataToPush = lastCasePush === null || lastCaseUpdate != null && lastCasePush.getTime() < (lastCaseUpdate === null || lastCaseUpdate === void 0 ? void 0 : lastCaseUpdate.getTime());
  return /*#__PURE__*/_react.default.createElement("p", null, actions.read && /*#__PURE__*/_react.default.createElement(IconWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "original",
    title: (_theCase$externalServ4 = theCase.externalService) === null || _theCase$externalServ4 === void 0 ? void 0 : _theCase$externalServ4.connectorName,
    type: (0, _utils.getConnectorIcon)(triggersActionsUi, lastPushedConnector === null || lastPushedConnector === void 0 ? void 0 : lastPushedConnector.actionTypeId),
    "data-test-subj": "cases-table-connector-icon"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `case-table-column-external`,
    title: (_theCase$externalServ5 = theCase.externalService) === null || _theCase$externalServ5 === void 0 ? void 0 : _theCase$externalServ5.connectorName,
    href: (_theCase$externalServ6 = theCase.externalService) === null || _theCase$externalServ6 === void 0 ? void 0 : _theCase$externalServ6.externalUrl,
    target: "_blank",
    "aria-label": i18n.PUSH_LINK_ARIA((_theCase$externalServ7 = theCase.externalService) === null || _theCase$externalServ7 === void 0 ? void 0 : _theCase$externalServ7.connectorName)
  }, (_theCase$externalServ8 = theCase.externalService) === null || _theCase$externalServ8 === void 0 ? void 0 : _theCase$externalServ8.externalTitle), hasDataToPush ? renderStringField(i18n.REQUIRES_UPDATE, `case-table-column-external-requiresUpdate`) : renderStringField(i18n.UP_TO_DATE, `case-table-column-external-upToDate`));
};
exports.ExternalServiceColumn = ExternalServiceColumn;
ExternalServiceColumn.displayName = 'ExternalServiceColumn';