"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSeverityAction = void 0;
var _react = require("react");
var _api = require("../../../../common/api");
var _use_bulk_update_case = require("../../../containers/use_bulk_update_case");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../../cases_context/use_cases_context");
var _config = require("../../severity/config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSeverityToasterMessage = (severity, cases) => {
  const totalCases = cases.length;
  const caseTitle = totalCases === 1 ? cases[0].title : '';
  switch (severity) {
    case _api.CaseSeverity.LOW:
      return i18n.SET_SEVERITY_LOW({
        totalCases,
        caseTitle
      });
    case _api.CaseSeverity.MEDIUM:
      return i18n.SET_SEVERITY_MEDIUM({
        totalCases,
        caseTitle
      });
    case _api.CaseSeverity.HIGH:
      return i18n.SET_SEVERITY_HIGH({
        totalCases,
        caseTitle
      });
    case _api.CaseSeverity.CRITICAL:
      return i18n.SET_SEVERITY_CRITICAL({
        totalCases,
        caseTitle
      });
    default:
      return '';
  }
};
const shouldDisableSeverity = (cases, severity) => cases.every(theCase => theCase.severity === severity);
const useSeverityAction = ({
  onAction,
  onActionSuccess,
  isDisabled,
  selectedSeverity
}) => {
  const {
    mutate: updateCases
  } = (0, _use_bulk_update_case.useUpdateCases)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const canUpdateSeverity = permissions.update;
  const isActionDisabled = isDisabled || !canUpdateSeverity;
  const handleUpdateCaseSeverity = (0, _react.useCallback)((selectedCases, severity) => {
    onAction();
    const casesToUpdate = selectedCases.map(theCase => ({
      severity,
      id: theCase.id,
      version: theCase.version
    }));
    updateCases({
      cases: casesToUpdate,
      successToasterTitle: getSeverityToasterMessage(severity, selectedCases)
    }, {
      onSuccess: onActionSuccess
    });
  }, [onAction, updateCases, onActionSuccess]);
  const getSeverityIcon = severity => selectedSeverity && selectedSeverity === severity ? 'check' : 'empty';
  const getActions = selectedCases => {
    return [{
      name: _config.severities[_api.CaseSeverity.LOW].label,
      icon: getSeverityIcon(_api.CaseSeverity.LOW),
      onClick: () => handleUpdateCaseSeverity(selectedCases, _api.CaseSeverity.LOW),
      disabled: isActionDisabled || shouldDisableSeverity(selectedCases, _api.CaseSeverity.LOW),
      'data-test-subj': 'cases-bulk-action-severity-low',
      key: 'cases-bulk-action-severity-low'
    }, {
      name: _config.severities[_api.CaseSeverity.MEDIUM].label,
      icon: getSeverityIcon(_api.CaseSeverity.MEDIUM),
      onClick: () => handleUpdateCaseSeverity(selectedCases, _api.CaseSeverity.MEDIUM),
      disabled: isActionDisabled || shouldDisableSeverity(selectedCases, _api.CaseSeverity.MEDIUM),
      'data-test-subj': 'cases-bulk-action-severity-medium',
      key: 'cases-bulk-action-severity-medium'
    }, {
      name: _config.severities[_api.CaseSeverity.HIGH].label,
      icon: getSeverityIcon(_api.CaseSeverity.HIGH),
      onClick: () => handleUpdateCaseSeverity(selectedCases, _api.CaseSeverity.HIGH),
      disabled: isActionDisabled || shouldDisableSeverity(selectedCases, _api.CaseSeverity.HIGH),
      'data-test-subj': 'cases-bulk-action-severity-high',
      key: 'cases-bulk-action-severity-high'
    }, {
      name: _config.severities[_api.CaseSeverity.CRITICAL].label,
      icon: getSeverityIcon(_api.CaseSeverity.CRITICAL),
      onClick: () => handleUpdateCaseSeverity(selectedCases, _api.CaseSeverity.CRITICAL),
      disabled: isActionDisabled || shouldDisableSeverity(selectedCases, _api.CaseSeverity.CRITICAL),
      'data-test-subj': 'cases-bulk-action-severity-critical',
      key: 'cases-bulk-action-severity-critical'
    }];
  };
  return {
    getActions,
    canUpdateSeverity
  };
};
exports.useSeverityAction = useSeverityAction;