"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsDarkTheme = useIsDarkTheme;
var _react = require("react");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _kibana = require("./lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const themeDefault = {
  darkMode: false
};

/**
 * Indicates if the currently applied theme is either dark or light.
 * @return {boolean} - Returns true if the currently applied theme is dark.
 */
function useIsDarkTheme() {
  const {
    services: {
      theme
    }
  } = (0, _kibana.useKibana)();
  const themeObservable$ = (0, _react.useMemo)(() => {
    var _theme$theme$;
    return (_theme$theme$ = theme === null || theme === void 0 ? void 0 : theme.theme$) !== null && _theme$theme$ !== void 0 ? _theme$theme$ : (0, _rxjs.of)(themeDefault);
  }, [theme]);
  const {
    darkMode
  } = (0, _useObservable.default)(themeObservable$, themeDefault);
  return darkMode;
}