"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidOwner = exports.getCaseOwnerByAppId = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidOwner = owner => Object.keys(_constants.OWNER_INFO).includes(owner);
exports.isValidOwner = isValidOwner;
const getCaseOwnerByAppId = currentAppId => {
  var _Object$values$find;
  return (_Object$values$find = Object.values(_constants.OWNER_INFO).find(info => info.appId === currentAppId)) === null || _Object$values$find === void 0 ? void 0 : _Object$values$find.id;
};
exports.getCaseOwnerByAppId = getCaseOwnerByAppId;