"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  DEFAULT_DATE_FORMAT: true,
  DEFAULT_DATE_FORMAT_TZ: true,
  CASE_SAVED_OBJECT: true,
  CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT: true,
  CASE_USER_ACTION_SAVED_OBJECT: true,
  CASE_COMMENT_SAVED_OBJECT: true,
  CASE_CONFIGURE_SAVED_OBJECT: true,
  SAVED_OBJECT_TYPES: true,
  CASES_URL: true,
  CASE_FIND_URL: true,
  CASE_DETAILS_URL: true,
  CASE_CONFIGURE_URL: true,
  CASE_CONFIGURE_DETAILS_URL: true,
  CASE_CONFIGURE_CONNECTORS_URL: true,
  CASE_COMMENTS_URL: true,
  CASE_FIND_ATTACHMENTS_URL: true,
  CASE_COMMENT_DETAILS_URL: true,
  CASE_COMMENT_DELETE_URL: true,
  CASE_PUSH_URL: true,
  CASE_REPORTERS_URL: true,
  CASE_STATUS_URL: true,
  CASE_TAGS_URL: true,
  CASE_USER_ACTIONS_URL: true,
  CASE_FIND_USER_ACTIONS_URL: true,
  CASE_ALERTS_URL: true,
  CASE_DETAILS_ALERTS_URL: true,
  CASE_METRICS_URL: true,
  CASE_METRICS_DETAILS_URL: true,
  CASES_INTERNAL_URL: true,
  INTERNAL_BULK_CREATE_ATTACHMENTS_URL: true,
  INTERNAL_BULK_GET_ATTACHMENTS_URL: true,
  INTERNAL_SUGGEST_USER_PROFILES_URL: true,
  INTERNAL_CONNECTORS_URL: true,
  INTERNAL_BULK_GET_CASES_URL: true,
  INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL: true,
  INTERNAL_CASE_USERS_URL: true,
  INTERNAL_DELETE_FILE_ATTACHMENTS_URL: true,
  INTERNAL_GET_CASE_CATEGORIES_URL: true,
  ACTION_URL: true,
  ACTION_TYPES_URL: true,
  CONNECTORS_URL: true,
  MAX_ALERTS_PER_CASE: true,
  MAX_DOCS_PER_PAGE: true,
  MAX_BULK_GET_ATTACHMENTS: true,
  MAX_CONCURRENT_SEARCHES: true,
  MAX_BULK_GET_CASES: true,
  MAX_COMMENTS_PER_PAGE: true,
  MAX_CATEGORY_FILTER_LENGTH: true,
  MAX_TITLE_LENGTH: true,
  MAX_CATEGORY_LENGTH: true,
  DEFAULT_FEATURES: true,
  CASES_TELEMETRY_TASK_NAME: true,
  CASE_TELEMETRY_SAVED_OBJECT: true,
  CASE_TELEMETRY_SAVED_OBJECT_ID: true,
  CREATE_CASES_CAPABILITY: true,
  READ_CASES_CAPABILITY: true,
  UPDATE_CASES_CAPABILITY: true,
  DELETE_CASES_CAPABILITY: true,
  PUSH_CASES_CAPABILITY: true,
  SUGGEST_USER_PROFILES_API_TAG: true,
  BULK_GET_USER_PROFILES_API_TAG: true,
  DEFAULT_USER_SIZE: true,
  MAX_ASSIGNEES_PER_CASE: true,
  NO_ASSIGNEES_FILTERING_KEYWORD: true,
  SEARCH_DEBOUNCE_MS: true,
  LOCAL_STORAGE_KEYS: true,
  LENS_ATTACHMENT_TYPE: true
};
exports.INTERNAL_SUGGEST_USER_PROFILES_URL = exports.INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL = exports.INTERNAL_GET_CASE_CATEGORIES_URL = exports.INTERNAL_DELETE_FILE_ATTACHMENTS_URL = exports.INTERNAL_CONNECTORS_URL = exports.INTERNAL_CASE_USERS_URL = exports.INTERNAL_BULK_GET_CASES_URL = exports.INTERNAL_BULK_GET_ATTACHMENTS_URL = exports.INTERNAL_BULK_CREATE_ATTACHMENTS_URL = exports.DELETE_CASES_CAPABILITY = exports.DEFAULT_USER_SIZE = exports.DEFAULT_FEATURES = exports.DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT = exports.CREATE_CASES_CAPABILITY = exports.CONNECTORS_URL = exports.CASE_USER_ACTION_SAVED_OBJECT = exports.CASE_USER_ACTIONS_URL = exports.CASE_TELEMETRY_SAVED_OBJECT_ID = exports.CASE_TELEMETRY_SAVED_OBJECT = exports.CASE_TAGS_URL = exports.CASE_STATUS_URL = exports.CASE_SAVED_OBJECT = exports.CASE_REPORTERS_URL = exports.CASE_PUSH_URL = exports.CASE_METRICS_URL = exports.CASE_METRICS_DETAILS_URL = exports.CASE_FIND_USER_ACTIONS_URL = exports.CASE_FIND_URL = exports.CASE_FIND_ATTACHMENTS_URL = exports.CASE_DETAILS_URL = exports.CASE_DETAILS_ALERTS_URL = exports.CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT = exports.CASE_CONFIGURE_URL = exports.CASE_CONFIGURE_SAVED_OBJECT = exports.CASE_CONFIGURE_DETAILS_URL = exports.CASE_CONFIGURE_CONNECTORS_URL = exports.CASE_COMMENT_SAVED_OBJECT = exports.CASE_COMMENT_DETAILS_URL = exports.CASE_COMMENT_DELETE_URL = exports.CASE_COMMENTS_URL = exports.CASE_ALERTS_URL = exports.CASES_URL = exports.CASES_TELEMETRY_TASK_NAME = exports.CASES_INTERNAL_URL = exports.BULK_GET_USER_PROFILES_API_TAG = exports.ACTION_URL = exports.ACTION_TYPES_URL = void 0;
Object.defineProperty(exports, "LENS_ATTACHMENT_TYPE", {
  enumerable: true,
  get: function () {
    return _visualizations.LENS_ATTACHMENT_TYPE;
  }
});
exports.UPDATE_CASES_CAPABILITY = exports.SUGGEST_USER_PROFILES_API_TAG = exports.SEARCH_DEBOUNCE_MS = exports.SAVED_OBJECT_TYPES = exports.READ_CASES_CAPABILITY = exports.PUSH_CASES_CAPABILITY = exports.NO_ASSIGNEES_FILTERING_KEYWORD = exports.MAX_TITLE_LENGTH = exports.MAX_DOCS_PER_PAGE = exports.MAX_CONCURRENT_SEARCHES = exports.MAX_COMMENTS_PER_PAGE = exports.MAX_CATEGORY_LENGTH = exports.MAX_CATEGORY_FILTER_LENGTH = exports.MAX_BULK_GET_CASES = exports.MAX_BULK_GET_ATTACHMENTS = exports.MAX_ASSIGNEES_PER_CASE = exports.MAX_ALERTS_PER_CASE = exports.LOCAL_STORAGE_KEYS = void 0;
var _owners = require("./owners");
Object.keys(_owners).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _owners[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _owners[key];
    }
  });
});
var _files = require("./files");
Object.keys(_files).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _files[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _files[key];
    }
  });
});
var _application = require("./application");
Object.keys(_application).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _application[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _application[key];
    }
  });
});
var _visualizations = require("./visualizations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATE_FORMAT = 'dateFormat';
exports.DEFAULT_DATE_FORMAT = DEFAULT_DATE_FORMAT;
const DEFAULT_DATE_FORMAT_TZ = 'dateFormat:tz';

/**
 * Saved objects
 */
exports.DEFAULT_DATE_FORMAT_TZ = DEFAULT_DATE_FORMAT_TZ;
const CASE_SAVED_OBJECT = 'cases';
exports.CASE_SAVED_OBJECT = CASE_SAVED_OBJECT;
const CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT = 'cases-connector-mappings';
exports.CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT = CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT;
const CASE_USER_ACTION_SAVED_OBJECT = 'cases-user-actions';
exports.CASE_USER_ACTION_SAVED_OBJECT = CASE_USER_ACTION_SAVED_OBJECT;
const CASE_COMMENT_SAVED_OBJECT = 'cases-comments';
exports.CASE_COMMENT_SAVED_OBJECT = CASE_COMMENT_SAVED_OBJECT;
const CASE_CONFIGURE_SAVED_OBJECT = 'cases-configure';

/**
 * If more values are added here please also add them here: x-pack/test/cases_api_integration/common/plugins
 */
exports.CASE_CONFIGURE_SAVED_OBJECT = CASE_CONFIGURE_SAVED_OBJECT;
const SAVED_OBJECT_TYPES = [CASE_SAVED_OBJECT, CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT, CASE_USER_ACTION_SAVED_OBJECT, CASE_COMMENT_SAVED_OBJECT, CASE_CONFIGURE_SAVED_OBJECT];

/**
 * Case routes
 */
exports.SAVED_OBJECT_TYPES = SAVED_OBJECT_TYPES;
const CASES_URL = '/api/cases';
exports.CASES_URL = CASES_URL;
const CASE_FIND_URL = `${CASES_URL}/_find`;
exports.CASE_FIND_URL = CASE_FIND_URL;
const CASE_DETAILS_URL = `${CASES_URL}/{case_id}`;
exports.CASE_DETAILS_URL = CASE_DETAILS_URL;
const CASE_CONFIGURE_URL = `${CASES_URL}/configure`;
exports.CASE_CONFIGURE_URL = CASE_CONFIGURE_URL;
const CASE_CONFIGURE_DETAILS_URL = `${CASES_URL}/configure/{configuration_id}`;
exports.CASE_CONFIGURE_DETAILS_URL = CASE_CONFIGURE_DETAILS_URL;
const CASE_CONFIGURE_CONNECTORS_URL = `${CASE_CONFIGURE_URL}/connectors`;
exports.CASE_CONFIGURE_CONNECTORS_URL = CASE_CONFIGURE_CONNECTORS_URL;
const CASE_COMMENTS_URL = `${CASE_DETAILS_URL}/comments`;
exports.CASE_COMMENTS_URL = CASE_COMMENTS_URL;
const CASE_FIND_ATTACHMENTS_URL = `${CASE_COMMENTS_URL}/_find`;
exports.CASE_FIND_ATTACHMENTS_URL = CASE_FIND_ATTACHMENTS_URL;
const CASE_COMMENT_DETAILS_URL = `${CASE_DETAILS_URL}/comments/{comment_id}`;
exports.CASE_COMMENT_DETAILS_URL = CASE_COMMENT_DETAILS_URL;
const CASE_COMMENT_DELETE_URL = `${CASE_DETAILS_URL}/comments/{comment_id}`;
exports.CASE_COMMENT_DELETE_URL = CASE_COMMENT_DELETE_URL;
const CASE_PUSH_URL = `${CASE_DETAILS_URL}/connector/{connector_id}/_push`;
exports.CASE_PUSH_URL = CASE_PUSH_URL;
const CASE_REPORTERS_URL = `${CASES_URL}/reporters`;
exports.CASE_REPORTERS_URL = CASE_REPORTERS_URL;
const CASE_STATUS_URL = `${CASES_URL}/status`;
exports.CASE_STATUS_URL = CASE_STATUS_URL;
const CASE_TAGS_URL = `${CASES_URL}/tags`;
exports.CASE_TAGS_URL = CASE_TAGS_URL;
const CASE_USER_ACTIONS_URL = `${CASE_DETAILS_URL}/user_actions`;
exports.CASE_USER_ACTIONS_URL = CASE_USER_ACTIONS_URL;
const CASE_FIND_USER_ACTIONS_URL = `${CASE_USER_ACTIONS_URL}/_find`;
exports.CASE_FIND_USER_ACTIONS_URL = CASE_FIND_USER_ACTIONS_URL;
const CASE_ALERTS_URL = `${CASES_URL}/alerts/{alert_id}`;
exports.CASE_ALERTS_URL = CASE_ALERTS_URL;
const CASE_DETAILS_ALERTS_URL = `${CASE_DETAILS_URL}/alerts`;
exports.CASE_DETAILS_ALERTS_URL = CASE_DETAILS_ALERTS_URL;
const CASE_METRICS_URL = `${CASES_URL}/metrics`;
exports.CASE_METRICS_URL = CASE_METRICS_URL;
const CASE_METRICS_DETAILS_URL = `${CASES_URL}/metrics/{case_id}`;

/**
 * Internal routes
 */
exports.CASE_METRICS_DETAILS_URL = CASE_METRICS_DETAILS_URL;
const CASES_INTERNAL_URL = '/internal/cases';
exports.CASES_INTERNAL_URL = CASES_INTERNAL_URL;
const INTERNAL_BULK_CREATE_ATTACHMENTS_URL = `${CASES_INTERNAL_URL}/{case_id}/attachments/_bulk_create`;
exports.INTERNAL_BULK_CREATE_ATTACHMENTS_URL = INTERNAL_BULK_CREATE_ATTACHMENTS_URL;
const INTERNAL_BULK_GET_ATTACHMENTS_URL = `${CASES_INTERNAL_URL}/{case_id}/attachments/_bulk_get`;
exports.INTERNAL_BULK_GET_ATTACHMENTS_URL = INTERNAL_BULK_GET_ATTACHMENTS_URL;
const INTERNAL_SUGGEST_USER_PROFILES_URL = `${CASES_INTERNAL_URL}/_suggest_user_profiles`;
exports.INTERNAL_SUGGEST_USER_PROFILES_URL = INTERNAL_SUGGEST_USER_PROFILES_URL;
const INTERNAL_CONNECTORS_URL = `${CASES_INTERNAL_URL}/{case_id}/_connectors`;
exports.INTERNAL_CONNECTORS_URL = INTERNAL_CONNECTORS_URL;
const INTERNAL_BULK_GET_CASES_URL = `${CASES_INTERNAL_URL}/_bulk_get`;
exports.INTERNAL_BULK_GET_CASES_URL = INTERNAL_BULK_GET_CASES_URL;
const INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL = `${CASES_INTERNAL_URL}/{case_id}/user_actions/_stats`;
exports.INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL = INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL;
const INTERNAL_CASE_USERS_URL = `${CASES_INTERNAL_URL}/{case_id}/_users`;
exports.INTERNAL_CASE_USERS_URL = INTERNAL_CASE_USERS_URL;
const INTERNAL_DELETE_FILE_ATTACHMENTS_URL = `${CASES_INTERNAL_URL}/{case_id}/attachments/files/_bulk_delete`;
exports.INTERNAL_DELETE_FILE_ATTACHMENTS_URL = INTERNAL_DELETE_FILE_ATTACHMENTS_URL;
const INTERNAL_GET_CASE_CATEGORIES_URL = `${CASES_INTERNAL_URL}/categories`;

/**
 * Action routes
 */
exports.INTERNAL_GET_CASE_CATEGORIES_URL = INTERNAL_GET_CASE_CATEGORIES_URL;
const ACTION_URL = '/api/actions';
exports.ACTION_URL = ACTION_URL;
const ACTION_TYPES_URL = `${ACTION_URL}/connector_types`;
exports.ACTION_TYPES_URL = ACTION_TYPES_URL;
const CONNECTORS_URL = `${ACTION_URL}/connectors`;

/**
 * Alerts
 */
exports.CONNECTORS_URL = CONNECTORS_URL;
const MAX_ALERTS_PER_CASE = 1000;

/**
 * Searching
 */
exports.MAX_ALERTS_PER_CASE = MAX_ALERTS_PER_CASE;
const MAX_DOCS_PER_PAGE = 10000;
exports.MAX_DOCS_PER_PAGE = MAX_DOCS_PER_PAGE;
const MAX_BULK_GET_ATTACHMENTS = MAX_DOCS_PER_PAGE;
exports.MAX_BULK_GET_ATTACHMENTS = MAX_BULK_GET_ATTACHMENTS;
const MAX_CONCURRENT_SEARCHES = 10;
exports.MAX_CONCURRENT_SEARCHES = MAX_CONCURRENT_SEARCHES;
const MAX_BULK_GET_CASES = 1000;
exports.MAX_BULK_GET_CASES = MAX_BULK_GET_CASES;
const MAX_COMMENTS_PER_PAGE = 100;
exports.MAX_COMMENTS_PER_PAGE = MAX_COMMENTS_PER_PAGE;
const MAX_CATEGORY_FILTER_LENGTH = 100;

/**
 * Validation
 */
exports.MAX_CATEGORY_FILTER_LENGTH = MAX_CATEGORY_FILTER_LENGTH;
const MAX_TITLE_LENGTH = 160;
exports.MAX_TITLE_LENGTH = MAX_TITLE_LENGTH;
const MAX_CATEGORY_LENGTH = 50;

/**
 * Cases features
 */
exports.MAX_CATEGORY_LENGTH = MAX_CATEGORY_LENGTH;
const DEFAULT_FEATURES = Object.freeze({
  alerts: {
    sync: true,
    enabled: true,
    isExperimental: false
  },
  metrics: []
});

/**
 * Task manager
 */
exports.DEFAULT_FEATURES = DEFAULT_FEATURES;
const CASES_TELEMETRY_TASK_NAME = 'cases-telemetry-task';

/**
 * Telemetry
 */
exports.CASES_TELEMETRY_TASK_NAME = CASES_TELEMETRY_TASK_NAME;
const CASE_TELEMETRY_SAVED_OBJECT = 'cases-telemetry';
exports.CASE_TELEMETRY_SAVED_OBJECT = CASE_TELEMETRY_SAVED_OBJECT;
const CASE_TELEMETRY_SAVED_OBJECT_ID = 'cases-telemetry';

/**
 * Cases UI Capabilities
 */
exports.CASE_TELEMETRY_SAVED_OBJECT_ID = CASE_TELEMETRY_SAVED_OBJECT_ID;
const CREATE_CASES_CAPABILITY = 'create_cases';
exports.CREATE_CASES_CAPABILITY = CREATE_CASES_CAPABILITY;
const READ_CASES_CAPABILITY = 'read_cases';
exports.READ_CASES_CAPABILITY = READ_CASES_CAPABILITY;
const UPDATE_CASES_CAPABILITY = 'update_cases';
exports.UPDATE_CASES_CAPABILITY = UPDATE_CASES_CAPABILITY;
const DELETE_CASES_CAPABILITY = 'delete_cases';
exports.DELETE_CASES_CAPABILITY = DELETE_CASES_CAPABILITY;
const PUSH_CASES_CAPABILITY = 'push_cases';

/**
 * Cases API Tags
 */

/**
 * This tag registered for the cases suggest user profiles API
 */
exports.PUSH_CASES_CAPABILITY = PUSH_CASES_CAPABILITY;
const SUGGEST_USER_PROFILES_API_TAG = 'casesSuggestUserProfiles';

/**
 * This tag is registered for the security bulk get API
 */
exports.SUGGEST_USER_PROFILES_API_TAG = SUGGEST_USER_PROFILES_API_TAG;
const BULK_GET_USER_PROFILES_API_TAG = 'bulkGetUserProfiles';

/**
 * User profiles
 */
exports.BULK_GET_USER_PROFILES_API_TAG = BULK_GET_USER_PROFILES_API_TAG;
const DEFAULT_USER_SIZE = 10;
exports.DEFAULT_USER_SIZE = DEFAULT_USER_SIZE;
const MAX_ASSIGNEES_PER_CASE = 10;
exports.MAX_ASSIGNEES_PER_CASE = MAX_ASSIGNEES_PER_CASE;
const NO_ASSIGNEES_FILTERING_KEYWORD = 'none';

/**
 * Delays
 */
exports.NO_ASSIGNEES_FILTERING_KEYWORD = NO_ASSIGNEES_FILTERING_KEYWORD;
const SEARCH_DEBOUNCE_MS = 500;

/**
 * Local storage keys
 */
exports.SEARCH_DEBOUNCE_MS = SEARCH_DEBOUNCE_MS;
const LOCAL_STORAGE_KEYS = {
  casesQueryParams: 'cases.list.queryParams',
  casesFilterOptions: 'cases.list.filterOptions'
};
exports.LOCAL_STORAGE_KEYS = LOCAL_STORAGE_KEYS;