"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionFindResponseRt = exports.UserActionFindRequestRt = exports.FindTypes = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _response = require("../response");
var _common = require("../common");
var _saved_object = require("../../../saved_object");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdditionalFilterTypes = {
  action: 'action',
  alert: 'alert',
  user: 'user',
  attachment: 'attachment'
};
const FindTypes = {
  ..._common.ActionTypes,
  ...AdditionalFilterTypes
};
exports.FindTypes = FindTypes;
const FindTypeFieldRt = rt.keyof(FindTypes);
const UserActionFindRequestRt = rt.exact(rt.partial({
  types: rt.array(FindTypeFieldRt),
  sortOrder: rt.union([rt.literal('desc'), rt.literal('asc')]),
  page: _saved_object.NumberFromString,
  perPage: _saved_object.NumberFromString
}));
exports.UserActionFindRequestRt = UserActionFindRequestRt;
const UserActionFindResponseRt = rt.strict({
  userActions: _response.UserActionsRt,
  page: rt.number,
  perPage: rt.number,
  total: rt.number
});
exports.UserActionFindResponseRt = UserActionFindResponseRt;