"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetConfigurationFindRequestRt = exports.ConfigurationsRt = exports.ConfigurationRt = exports.ConfigurationRequestRt = exports.ConfigurationPatchRequestRt = exports.ConfigurationBasicWithoutOwnerRt = exports.ConfigurationAttributesRt = exports.ConfigurationActivityFieldsRt = exports.CaseConfigureRequestParamsRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _connector = require("../connectors/connector");
var _mappings = require("../connectors/mappings");
var _user = require("../user");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClosureTypeRt = rt.union([rt.literal('close-by-user'), rt.literal('close-by-pushing')]);
const ConfigurationBasicWithoutOwnerRt = rt.strict({
  /**
   * The external connector
   */
  connector: _connector.CaseConnectorRt,
  /**
   * Whether to close the case after it has been synced with the external system
   */
  closure_type: ClosureTypeRt
});
exports.ConfigurationBasicWithoutOwnerRt = ConfigurationBasicWithoutOwnerRt;
const CasesConfigureBasicRt = rt.intersection([ConfigurationBasicWithoutOwnerRt, rt.strict({
  /**
   * The plugin owner that manages this configuration
   */
  owner: rt.string
})]);
const ConfigurationRequestRt = CasesConfigureBasicRt;
exports.ConfigurationRequestRt = ConfigurationRequestRt;
const ConfigurationPatchRequestRt = rt.intersection([rt.exact(rt.partial(ConfigurationBasicWithoutOwnerRt.type.props)), rt.strict({
  version: rt.string
})]);
exports.ConfigurationPatchRequestRt = ConfigurationPatchRequestRt;
const ConfigurationActivityFieldsRt = rt.strict({
  created_at: rt.string,
  created_by: _user.UserRt,
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_user.UserRt, rt.null])
});
exports.ConfigurationActivityFieldsRt = ConfigurationActivityFieldsRt;
const ConfigurationAttributesRt = rt.intersection([CasesConfigureBasicRt, ConfigurationActivityFieldsRt]);
exports.ConfigurationAttributesRt = ConfigurationAttributesRt;
const ConfigurationRt = rt.intersection([ConfigurationAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string,
  error: rt.union([rt.string, rt.null]),
  owner: rt.string,
  mappings: _mappings.ConnectorMappingsRt
})]);
exports.ConfigurationRt = ConfigurationRt;
const GetConfigurationFindRequestRt = rt.exact(rt.partial({
  /**
   * The configuration plugin owner to filter the search by. If this is left empty the results will include all configurations
   * that the user has permissions to access
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}));
exports.GetConfigurationFindRequestRt = GetConfigurationFindRequestRt;
const CaseConfigureRequestParamsRt = rt.strict({
  configuration_id: rt.string
});
exports.CaseConfigureRequestParamsRt = CaseConfigureRequestParamsRt;
const ConfigurationsRt = rt.array(ConfigurationRt);
exports.ConfigurationsRt = ConfigurationsRt;