"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workpadServiceFactory = exports.promiseTimeout = exports.importWorkpad = exports.getSomeWorkpads = exports.getSomeTemplates = exports.getNoTemplates = exports.findSomeWorkpads = exports.findSomeTemplates = exports.findNoWorkpads = exports.findNoTemplates = exports.TIMEOUT = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _defaults = require("../../state/defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

const TIMEOUT = 500;
exports.TIMEOUT = TIMEOUT;
const promiseTimeout = time => () => new Promise(resolve => setTimeout(resolve, time));
exports.promiseTimeout = promiseTimeout;
const DAY = 86400000;
const JAN_1_2000 = 946684800000;
const getWorkpads = (count = 3) => {
  const workpads = [];
  for (let i = 0; i < count; i++) {
    workpads[i] = {
      ...(0, _defaults.getDefaultWorkpad)(),
      name: `Workpad ${i}`,
      id: `workpad-${i}`,
      '@created': (0, _moment.default)(JAN_1_2000 + DAY * i).toDate(),
      '@timestamp': (0, _moment.default)(JAN_1_2000 + DAY * (i + 1)).toDate()
    };
  }
  return workpads;
};
const getSomeWorkpads = (count = 3) => getWorkpads(count);
exports.getSomeWorkpads = getSomeWorkpads;
const findSomeWorkpads = (count = 3, timeout = TIMEOUT) => _term => {
  return Promise.resolve().then(promiseTimeout(timeout)).then(() => ({
    total: count,
    workpads: getSomeWorkpads(count)
  }));
};
exports.findSomeWorkpads = findSomeWorkpads;
const templates = [{
  id: 'test1-id',
  name: 'test1',
  help: 'This is a test template',
  tags: ['tag1', 'tag2'],
  template_key: 'test1-key'
}, {
  id: 'test2-id',
  name: 'test2',
  help: 'This is a second test template',
  tags: ['tag2', 'tag3'],
  template_key: 'test2-key'
}];
const findNoWorkpads = (timeout = TIMEOUT) => _term => {
  return Promise.resolve().then(promiseTimeout(timeout)).then(() => ({
    total: 0,
    workpads: []
  }));
};
exports.findNoWorkpads = findNoWorkpads;
const findSomeTemplates = (timeout = TIMEOUT) => () => {
  return Promise.resolve().then(promiseTimeout(timeout)).then(() => getSomeTemplates());
};
exports.findSomeTemplates = findSomeTemplates;
const findNoTemplates = (timeout = TIMEOUT) => () => {
  return Promise.resolve().then(promiseTimeout(timeout)).then(() => getNoTemplates());
};
exports.findNoTemplates = findNoTemplates;
const importWorkpad = workpad => Promise.resolve(workpad);
exports.importWorkpad = importWorkpad;
const getNoTemplates = () => ({
  templates: []
});
exports.getNoTemplates = getNoTemplates;
const getSomeTemplates = () => ({
  templates
});
exports.getSomeTemplates = getSomeTemplates;
const workpadServiceFactory = () => ({
  get: id => Promise.resolve({
    ...(0, _defaults.getDefaultWorkpad)(),
    id
  }),
  resolve: id => Promise.resolve({
    outcome: 'exactMatch',
    workpad: {
      ...(0, _defaults.getDefaultWorkpad)(),
      id
    }
  }),
  findTemplates: findNoTemplates(),
  create: workpad => Promise.resolve(workpad),
  import: workpad => importWorkpad(workpad),
  createFromTemplate: _templateId => Promise.resolve((0, _defaults.getDefaultWorkpad)()),
  find: findNoWorkpads(),
  remove: _id => Promise.resolve(),
  update: (id, workpad) => Promise.resolve(),
  updateWorkpad: (id, workpad) => Promise.resolve(),
  updateAssets: (id, assets) => Promise.resolve(),
  getRuntimeZip: workpad => Promise.resolve(new Blob([JSON.stringify(workpad)], {
    type: 'application/json'
  }))
});
exports.workpadServiceFactory = workpadServiceFactory;