"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.platformServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const platformServiceFactory = ({
  coreStart,
  initContext,
  startPlugins
}) => {
  var _startPlugins$spaces, _startPlugins$spaces2;
  if (!initContext) {
    throw new Error('Canvas platform service requires init context');
  }
  return {
    getBasePath: coreStart.http.basePath.get,
    getBasePathInterface: () => coreStart.http.basePath,
    getElasticWebsiteUrl: () => coreStart.docLinks.ELASTIC_WEBSITE_URL,
    getDocLinkVersion: () => coreStart.docLinks.DOC_LINK_VERSION,
    getKibanaVersion: () => initContext.env.packageInfo.version,
    // TODO: is there a better type for this?  The capabilities type allows for a Record,
    // though we don't do this.  So this cast may be the best option.
    getHasWriteAccess: () => coreStart.application.capabilities.canvas.save,
    getUISetting: coreStart.uiSettings.get.bind(coreStart.uiSettings),
    hasHeaderBanner$: coreStart.chrome.hasHeaderBanner$,
    setBreadcrumbs: coreStart.chrome.setBreadcrumbs,
    setRecentlyAccessed: coreStart.chrome.recentlyAccessed.add,
    setFullscreen: coreStart.chrome.setIsVisible,
    redirectLegacyUrl: (_startPlugins$spaces = startPlugins.spaces) === null || _startPlugins$spaces === void 0 ? void 0 : _startPlugins$spaces.ui.redirectLegacyUrl,
    getLegacyUrlConflict: (_startPlugins$spaces2 = startPlugins.spaces) === null || _startPlugins$spaces2 === void 0 ? void 0 : _startPlugins$spaces2.ui.components.getLegacyUrlConflict,
    getUISettings: () => coreStart.uiSettings,
    getHttp: () => coreStart.http,
    getSavedObjectsManagement: () => startPlugins.savedObjectsManagement
  };
};
exports.platformServiceFactory = platformServiceFactory;