"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navLinkServiceFactory = void 0;
var _constants = require("../../../common/lib/constants");
var _storage = require("../../lib/storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const navLinkServiceFactory = ({
  coreStart,
  appUpdater
}) => ({
  updatePath: path => {
    appUpdater === null || appUpdater === void 0 ? void 0 : appUpdater.next(() => ({
      defaultPath: `${path}`
    }));
    (0, _storage.getSessionStorage)().set(`${_constants.SESSIONSTORAGE_LASTPATH}:${coreStart.http.basePath.get()}`, path);
  }
});
exports.navLinkServiceFactory = navLinkServiceFactory;