"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readableColor = readableColor;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function readableColor(background, light = '#FFF', dark = '#333') {
  try {
    return _chromaJs.default.contrast(background, '#000') < 7 ? light : dark;
  } catch (e) {
    return dark;
  }
}