"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.subMultitree = exports.shallowEqual = exports.removeDuplicates = exports.not = exports.mean = exports.map = exports.identity = exports.flatten = exports.disjunctiveUnion = exports.arrayToMap = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * flatten
 *
 * Flattens an array of arrays into an array
 *
 * @param {*[][]} arrays
 * @returns *[]
 */
const flatten = arrays => [].concat(...arrays);

/**
 * identity
 *
 * @param d
 * @returns d
 */
exports.flatten = flatten;
const identity = d => d;

/**
 * map
 *
 * Maps a function over an array
 *
 * Passing the index and the array are avoided
 *
 * @param {Function} fun
 * @returns {function(*): *}
 */
exports.identity = identity;
const map = fun => array => array.map(value => fun(value));

/**
 * disjunctiveUnion
 *
 * @param {Function} keyFun
 * @param {*[]} set1
 * @param {*[]} set2
 * @returns *[]
 */
exports.map = map;
const disjunctiveUnion = (keyFun, set1, set2) => set1.filter(s1 => !set2.find(s2 => keyFun(s2) === keyFun(s1))).concat(set2.filter(s2 => !set1.find(s1 => keyFun(s1) === keyFun(s2))));

/**
 *
 * @param {number} a
 * @param {number} b
 * @returns {number} the mean of the two parameters
 */
exports.disjunctiveUnion = disjunctiveUnion;
const mean = (a, b) => (a + b) / 2;
exports.mean = mean;
const shallowEqual = (a, b) => {
  if (a === b) {
    return true;
  }
  if (a.length !== b.length) {
    return false;
  }
  for (let i = 0; i < a.length; i++) {
    if (a[i] !== b[i]) {
      return false;
    }
  }
  return true;
};
exports.shallowEqual = shallowEqual;
const not = fun => (...args) => !fun(...args);
exports.not = not;
const removeDuplicates = (idFun, a) => a.filter((d, i) => a.findIndex(s => idFun(s) === idFun(d)) === i);
exports.removeDuplicates = removeDuplicates;
const arrayToMap = a => Object.assign({}, ...a.map(d => ({
  [d]: true
})));
exports.arrayToMap = arrayToMap;
const subMultitree = (pk, fk, elements, inputRoots) => {
  const getSubgraphs = roots => {
    const children = flatten(roots.map(r => elements.filter(e => fk(e) === pk(r))));
    if (children.length) {
      return [...roots, ...getSubgraphs(children, elements)];
    } else {
      return roots;
    }
  };
  return getSubgraphs(inputRoots);
};
exports.subMultitree = subMultitree;