"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FullscreenControlWithContext = exports.FullscreenControl = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _recompose = require("recompose");
var _transient = require("../../../state/actions/transient");
var _workpad = require("../../../state/selectors/workpad");
var _ui_metric = require("../../../lib/ui_metric");
var _constants = require("../../../../common/lib/constants");
var _transitions_registry = require("../../../lib/transitions_registry");
var _elements = require("../../../state/actions/elements");
var _workpad_routing_context = require("../../../routes/workpad/workpad_routing_context");
var _fullscreen_control = require("./fullscreen_control");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: a lot of this is borrowed code from `/components/workpad/index.js`.
// We should consider extracting the next/prev page logic into to a shared lib file.
const mapStateToProps = state => ({
  workpadId: (0, _workpad.getWorkpad)(state).id,
  pages: (0, _workpad.getPages)(state),
  selectedPageNumber: (0, _workpad.getSelectedPageIndex)(state) + 1
});
const mapDispatchToProps = dispatch => ({
  fetchAllRenderables: () => dispatch((0, _elements.fetchAllRenderables)())
});
const FullscreenControlWithContext = props => {
  const {
    isFullscreen,
    autoplayInterval,
    nextPage,
    previousPage,
    setFullscreen,
    setIsAutoplayPaused,
    isAutoplayPaused
  } = (0, _react.useContext)(_workpad_routing_context.WorkpadRoutingContext);
  const autoplayEnabled = autoplayInterval > 0 ? true : false;
  const dispatch = (0, _reactRedux.useDispatch)();
  const setFullscreenWithEffects = (0, _react.useCallback)(value => {
    value && dispatch((0, _transient.selectToplevelNodes)([]));
    setFullscreen(value);
    if (value === true) {
      (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.COUNT, autoplayEnabled ? [_constants.LAUNCHED_FULLSCREEN, _constants.LAUNCHED_FULLSCREEN_AUTOPLAY] : _constants.LAUNCHED_FULLSCREEN);
    }
  }, [dispatch, setFullscreen, autoplayEnabled]);
  const toggleAutoplay = (0, _react.useCallback)(() => {
    setIsAutoplayPaused(!isAutoplayPaused);
  }, [setIsAutoplayPaused, isAutoplayPaused]);
  return /*#__PURE__*/_react.default.createElement(_fullscreen_control.FullscreenControl, (0, _extends2.default)({
    isFullscreen: isFullscreen,
    nextPage: nextPage,
    previousPage: previousPage,
    autoplayEnabled: autoplayEnabled,
    setFullscreen: setFullscreenWithEffects,
    toggleAutoplay: toggleAutoplay
  }, props));
};
exports.FullscreenControlWithContext = FullscreenControlWithContext;
const FullscreenControl = (0, _recompose.compose)((0, _recompose.getContext)({
  router: _propTypes.default.object
}), (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps), (0, _recompose.withState)('transition', 'setTransition', null), (0, _recompose.withState)('prevSelectedPageNumber', 'setPrevSelectedPageNumber', 0), (0, _recompose.withProps)(({
  selectedPageNumber,
  prevSelectedPageNumber,
  transition
}) => {
  function getAnimation(pageNumber) {
    if (!transition || !transition.name) {
      return null;
    }
    if (![selectedPageNumber, prevSelectedPageNumber].includes(pageNumber)) {
      return null;
    }
    const {
      enter,
      exit
    } = _transitions_registry.transitionsRegistry.get(transition.name);
    const laterPageNumber = Math.max(selectedPageNumber, prevSelectedPageNumber);
    const name = pageNumber === laterPageNumber ? enter : exit;
    const direction = prevSelectedPageNumber > selectedPageNumber ? 'reverse' : 'normal';
    return {
      name,
      direction
    };
  }
  return {
    getAnimation
  };
}), (0, _recompose.withHandlers)({
  onTransitionEnd: ({
    setTransition
  }) => () => setTransition(null)
}))(FullscreenControlWithContext);
exports.FullscreenControl = FullscreenControl;