"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.WorkpadsContext = exports.MyWorkpads = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../hooks");
var _loading = require("../loading");
var _my_workpads = require("./my_workpads.component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkpadsContext = /*#__PURE__*/(0, _react.createContext)(null);
exports.WorkpadsContext = WorkpadsContext;
const MyWorkpads = () => {
  const findWorkpads = (0, _hooks.useFindWorkpads)();
  const [isMounted, setIsMounted] = (0, _react.useState)(false);
  const [workpads, setWorkpads] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const mount = async () => {
      const response = await findWorkpads('');
      setIsMounted(true);
      setWorkpads((response === null || response === void 0 ? void 0 : response.workpads) || []);
    };
    mount();
  }, [setIsMounted, findWorkpads]);
  if (!isMounted) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, null);
  }
  return /*#__PURE__*/_react.default.createElement(WorkpadsContext.Provider, {
    value: {
      workpads,
      setWorkpads
    }
  }, /*#__PURE__*/_react.default.createElement(_my_workpads.MyWorkpads, {
    workpads
  }));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.MyWorkpads = MyWorkpads;
var _default = MyWorkpads;
exports.default = _default;