"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionFormContextPending = void 0;
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _loading = require("../loading");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FunctionFormContextPending = props => {
  const {
    contextExpression,
    expressionType,
    context,
    updateContext
  } = props;
  const prevContextExpression = (0, _usePrevious.default)(contextExpression);
  const fetchContext = (0, _react.useCallback)((force = false) => {
    // dispatch context update if none is provided
    if (force || context == null && expressionType.requiresContext) {
      updateContext();
    }
  }, [context, expressionType.requiresContext, updateContext]);
  (0, _react.useEffect)(() => {
    const forceUpdate = expressionType.requiresContext && prevContextExpression !== contextExpression;
    fetchContext(forceUpdate);
  }, [contextExpression, expressionType, fetchContext, prevContextExpression]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasFunctionForm canvasFunctionForm--loading"
  }, /*#__PURE__*/_react.default.createElement(_loading.Loading, null));
};
exports.FunctionFormContextPending = FunctionFormContextPending;