"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasourcePreview = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _loading = require("../../loading");
var _services = require("../../../services");
var _datasource_preview = require("./datasource_preview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasourcePreview = props => {
  const [datatable, setDatatable] = (0, _react.useState)();
  const expressionsService = (0, _services.useExpressionsService)();
  (0, _react.useEffect)(() => {
    expressionsService.interpretAst({
      type: 'expression',
      chain: [props.function]
    }, {}).then(setDatatable);
  }, [expressionsService, props.function, setDatatable]);
  if (!datatable) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, props);
  }
  return /*#__PURE__*/_react.default.createElement(_datasource_preview.DatasourcePreview, (0, _extends2.default)({}, props, {
    datatable: datatable,
    setDatatable: setDatatable
  }));
};
exports.DatasourcePreview = DatasourcePreview;
DatasourcePreview.propTypes = {
  function: _propTypes.PropTypes.object
};