"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.AssetManagerServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
var _manage_index_templates = require("./lib/manage_index_templates");
var _routes = require("./routes");
var _assets_template = require("./templates/assets_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const config = {
  schema: _configSchema.schema.object({
    alphaEnabled: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
exports.config = config;
class AssetManagerServerPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.config = context.config.get();
    this.logger = context.logger.get();
  }
  setup(core) {
    // Check for config value and bail out if not "alpha-enabled"
    if (!this.config.alphaEnabled) {
      this.logger.info('Asset manager plugin [tech preview] is NOT enabled');
      return;
    }
    this.logger.info('Asset manager plugin [tech preview] is enabled');
    const router = core.http.createRouter();
    (0, _routes.setupRoutes)({
      router
    });
    return {};
  }
  start(core) {
    // Check for config value and bail out if not "alpha-enabled"
    if (!this.config.alphaEnabled) {
      return;
    }

    // create/update assets-* index template
    (0, _manage_index_templates.upsertTemplate)({
      esClient: core.elasticsearch.client.asInternalUser,
      template: _assets_template.assetsIndexTemplateConfig,
      logger: this.logger
    });
  }
  stop() {}
}
exports.AssetManagerServerPlugin = AssetManagerServerPlugin;